package games.geniusSquare.game

import algorithmX.AlgorithmX
import algorithmX.printer.Printer
import cubes.*
import cubes.Formalisation
import cubes.point.Point3D
import cubes.Shape
import cubes.point.Point
import cubes.Difficulty

open class GeniusSquareBase {

    //attributes --------------------------------------------------------------
    private val fixedShapes = mutableSetOf<Shape>()

    //constants ---------------------------------------------------------------
    companion object {
        val FIXED_SHAPE_NAME = "o"
    }
    private val DIFFICULTY_STRING = "difficulty:"
    private val RESULT_STRING = "| number of solutions:"
    private val FIRST_LETTER = 'A'
    private val EMPTY_STRING = ""
    private val DELIMETER = " "
    private val GAME_SIZE = 6
    private val PRECISION = 20
    private var PUZZLE : Puzzle
    private val REPEATIBLE = setOf<Shape>()
    private val SHAPES = setOf(
            Shape("L", setOf(
                    Point3D(0,1),
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(2,0)
            )),
            Shape("T", setOf(
                    Point3D(1,1),
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(2,0)
            )),
            Shape("S", setOf(
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(1,1),
                    Point3D(2,1)
            )),
            Shape("V", setOf(
                    Point3D(0,1),
                    Point3D(0,0),
                    Point3D(1,0)
            )),
            Shape("O", setOf(
                    Point3D(0,1),
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(1,1)
            )),
            Shape("1", setOf(
                    Point3D(0,0)
            )),
            Shape("2", setOf(
                    Point3D(0,0),
                    Point3D(1,0)
            )),
            Shape("3", setOf(
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(2,0)
            )),
            Shape("4", setOf(
                    Point3D(0,0),
                    Point3D(1,0),
                    Point3D(2,0),
                    Point3D(3,0)
            ))
    )
    protected var DICES = listOf(
            listOf(
                    Pair('F', 2),
                    Pair('E', 1),
                    Pair('A', 5),
                    Pair('B', 6)
            ),
            listOf(
                    Pair('A', 1),
                    Pair('C', 1),
                    Pair('D', 1),
                    Pair('D', 2),
                    Pair('E', 2),
                    Pair('F', 3)
            ),
            listOf(
                    Pair('F', 4),
                    Pair('E', 5),
                    Pair('F', 5),
                    Pair('D', 5),
                    Pair('E', 6),
                    Pair('E', 4)
            ),
            listOf(
                    Pair('D', 4),
                    Pair('B', 4),
                    Pair('E', 3),
                    Pair('C', 4),
                    Pair('C', 3),
                    Pair('D', 3)
            ),
            listOf(
                    Pair('A', 6),
                    Pair('F', 1)
            ),
            listOf(
                    Pair('C', 5),
                    Pair('F', 6),
                    Pair('A', 4),
                    Pair('D', 6),
                    Pair('C', 6),
                    Pair('B', 5)
            ),
            listOf(
                    Pair('B', 3),
                    Pair('A', 3),
                    Pair('C', 2),
                    Pair('B', 2),
                    Pair('A', 2),
                    Pair('B', 1)
            )
    )

    //constructors --------------------------------------------------------------------------
    init {
        val puzzlePoints = mutableSetOf<Point>()
        for (x in 0 until GAME_SIZE) {
            for (y in 0 until GAME_SIZE) {
                puzzlePoints.add(Point3D(x,y))
            }
        }
        PUZZLE = Puzzle(puzzlePoints)
    }

    //methods -------------------------------------------------------------------------------
    protected open fun generateGameAndSolveIt(dices : List<List<Pair<Char, Int>>>,
                                              indices : List<Int>,
                                              printer : Printer,
                                              allSolutions : Boolean,
                                              printSolution : Boolean,
                                              printResults : Boolean,
                                              printDifficulty: Boolean) : Int {
        generateShapes(dices, indices)
        val task = Task(PUZZLE, SHAPES, REPEATIBLE, fixedShapes)
        val pair = Formalisation().createMatrixAndNamesFromTask(task)
        printer.reset()
        val numberOfSolutions = AlgorithmX(
            pair.first,
            pair.second,
            printer,
            allSolutions
        ).solve()
        if (printResults) {
            printResults(dices, indices, numberOfSolutions)
        }
        if (printDifficulty) {
            val difficulty = Difficulty().calculateDifficulty(task)
            printDifficulty(difficulty)
        }
        if (printSolution) {
            printer.print()
        }
        return numberOfSolutions
    }

    private fun generateShapes(dices : List<List<Pair<Char, Int>>>,
                               indices : List<Int>) {
        fixedShapes.clear()
        for (i in indices.indices) {
            addShape(dices[i][indices[i]])
        }
    }

    private fun addShape(pair : Pair<Char, Int>) {
        val x = pair.second - 1
        val y = pair.first.toUpperCase() - FIRST_LETTER
        val fixedShape = Shape(FIXED_SHAPE_NAME, setOf(Point3D(x, y)))
        fixedShapes.add(fixedShape)
    }

    protected fun printIndices(dices : List<List<Pair<Char, Int>>>,
                               indices : List<Int>) : String {
        var indicesString = EMPTY_STRING
        for (i in indices.indices) {
            val pair = dices[i][indices[i]]
            indicesString += pair.first.toUpperCase() + pair.second.toString() + DELIMETER
        }
        return indicesString
    }

    private fun printResults(dices : List<List<Pair<Char, Int>>>,
                             indices : List<Int>,
                             numberOfSolutions : Int) {
        println("${printIndices(dices, indices)}$RESULT_STRING $numberOfSolutions")
    }

    private fun printDifficulty(difficulty : Double) {
        println("$DIFFICULTY_STRING %.${PRECISION}f".format(difficulty))
    }

}