package games.geniusSquare.game

import algorithmX.printer.NamePrinter
import java.util.*

class GeniusSquareCreateGames : GeniusSquareAllGames() {

    //attributes -------------------------------------------------------------------------------
    private var depth = 0
    private val random = Random()
    private var dices = listOf<MutableList<Pair<Char, Int>>>()

    //constants --------------------------------------------------------------------------------
    private val DEPTH_OF_CHANGE = 3
    private val MINIMAL_NUMBER = 1
    private val MAXIMAL_NUMBER = 6
    private val DEPTH = 0
    private val PRINT = false
    private val PRINTER = NamePrinter()

    //methods ----------------------------------------------------------------------------------
    fun createNewGames() {
        depth = DEPTH
        dices = copyDices(DICES)
        createNewGamesFromExistingGamesTactic()
        DICES = dices
        printDices(dices)
    }

    private fun copyDices(dices: List<List<Pair<Char, Int>>>) : List<MutableList<Pair<Char, Int>>>{
        val dicesCopy = mutableListOf<MutableList<Pair<Char, Int>>>()
        for (dice in dices) {
            val diceCopy = mutableListOf<Pair<Char, Int>>()
            for (position in dice) {
                diceCopy.add(position)
            }
            dicesCopy.add(diceCopy)
        }
        return dicesCopy
    }

    private fun createNewGamesFromExistingGamesTactic() {
        if (depth == DEPTH_OF_CHANGE) {
            return
        }
        while (true) {
            val dicesCopy = copyDices(dices)
            movePosition(dicesCopy)
            if (doSolveAllGames(dicesCopy, PRINTER, PRINT, PRINT, PRINT)) {
                depth++
                dices = dicesCopy
                return createNewGamesFromExistingGamesTactic()
            }
        }
    }

    private fun movePosition(dices: List<MutableList<Pair<Char, Int>>>) {
        while (true) {
            val diceIndexFrom = random.nextInt(dices.size)
            if (dices[diceIndexFrom].size == MINIMAL_NUMBER) {
                continue
            }
            val positionIndexFrom = random.nextInt(dices[diceIndexFrom].size)
            while (true) {
                val diceIndexTo = random.nextInt(dices.size)
                if (diceIndexTo == diceIndexFrom || dices[diceIndexTo].size == MAXIMAL_NUMBER) {
                    continue
                }
                dices[diceIndexTo].add(dices[diceIndexFrom][positionIndexFrom])
                dices[diceIndexFrom].removeAt(positionIndexFrom)
                return
            }
        }
    }

    private fun printDices(dices: List<List<Pair<Char, Int>>>) {
        for (dice in dices) {
            for (position in dice) {
                print("${position.first.toUpperCase()}${position.second} ")
            }
            println()
        }
        println()
    }

}