package games.geniusSquare.game

import algorithmX.printer.Printer
import java.util.*

class GeniusSquareRandomGame : GeniusSquareBase() {

    //attributes---------------------------------------------------
    private val random = Random()

    //methods ------------------------------------------------------
    fun solveRandomGame(printer : Printer,
                        allSolutions : Boolean,
                        printSolution : Boolean,
                        printResults : Boolean,
                        printDifficulty: Boolean) {
        generateGameAndSolveIt(
            DICES,
            randomIndices(),
            printer,
            allSolutions,
            printSolution,
            printResults,
            printDifficulty
        )
    }

    private fun randomIndices() : List<Int> {
        val indices = mutableListOf<Int>()
        for (dice in DICES) {
            indices.add(random.nextInt(dice.size))
        }
        return indices
    }

}