package games.geniusSquare.printer

import org.lwjgl.glfw.GLFW
import games.geniusSquare.game.GeniusSquareBase
import games.Colour
import games.ubongo.printer.GLUbongoPrinter

class GLGeniusSquarePrinter : GLUbongoPrinter() {

    //constants -----------------------------------------------------------------------
    private val FIXED_COLOR = Colour()
    override val WINDOW_NAME = "Square Game"

    //methods -------------------------------------------------------------------------
    override fun keyReact(window : Long, key : Int) {
        when (key) {
            GLFW.GLFW_KEY_ESCAPE -> GLFW.glfwSetWindowShouldClose(window, true)
            GLFW.GLFW_KEY_LEFT -> changeSolutionIndex(PREVIOUS)
            GLFW.GLFW_KEY_RIGHT -> changeSolutionIndex(NEXT)
            GLFW.GLFW_KEY_KP_SUBTRACT -> changeDistance(PREVIOUS)
            GLFW.GLFW_KEY_KP_ADD -> changeDistance(NEXT)
            GLFW.GLFW_KEY_ENTER -> animate()
            GLFW.GLFW_KEY_SPACE -> recolour()
        }
    }

    override fun addColor(colour: Colour) {
        if (colour != FIXED_COLOR) {
            super.addColor(colour)
        }
    }

    override fun generateColour(name : String) : Colour {
        if (name == GeniusSquareBase.FIXED_SHAPE_NAME) {
            return FIXED_COLOR
        }
        return super.generateColour(name)
    }

}