package games.ubongo.printer

import algorithmX.name.Name
import algorithmX.printer.Printer
import cubes.point.Point3D

open class StringUbongoPrinter : Printer {

    //attributes ------------------------------------------------------------------------
    private var char = 'A'
    override val solutions: MutableList<List<List<Name>>> = mutableListOf()

    //constants -------------------------------------------------------------------------
    private val START_CHAR = 'A'

    //methods ---------------------------------------------------------------------------
    override fun print() {
        for (solution in solutions) {
            printOutput(buildOutput(solution))
        }
    }

    private fun buildOutput(names : List<List<Name>>) : List<List<List<Char>>> {
        char = START_CHAR
        val output = mutableListOf<MutableList<MutableList<Char>>>()
        for (row in names) {
            val nameChar = selectName(row)
            for (name in row) {
                if (name is Point3D) {
                    while (output.size <= name.z) {
                        output.add(mutableListOf())
                    }
                    while (output[name.z].size <= name.y) {
                        output[name.z].add(mutableListOf())
                    }
                    while (output[name.z][name.y].size <= name.x) {
                        output[name.z][name.y].add(' ')
                    }
                    output[name.z][name.y][name.x] = nameChar
                }
            }
        }
        return output
    }

    protected open fun selectName(row : List<Name>) : Char {
        val nameChar = char
        char++
        return nameChar
    }

    private fun printOutput(output : List<List<List<Char>>>) {
        for (z in 0 until output.size) {
            for (y in 0 until output[z].size) {
                for (x in 0 until output[z][y].size) {
                    print(output[z][y][x])
                }
                println()
            }
            println()
        }
        println("\n\n")
    }

}