package tests

import games.geniusSquare.GeniusSquare
import games.geniusSquare.printer.GLGeniusSquarePrinter
import java.lang.IllegalArgumentException

class TestGeniusSquare {

    companion object {

        fun testAll() {
            testSpecifiedGames()
            testWrongInputs()
            testAllCreatedGame()
            testAllGames()
            testCreateGame()
        }

        fun testSpecifiedGames() {
            GeniusSquare.solveSpecifiedGame("E1 E2 E6 D4 A6 C6 A2", GLGeniusSquarePrinter())
            GeniusSquare.solveSpecifiedGame("B3   B4 F1 F2    F3  F4 F6", GLGeniusSquarePrinter())
            GeniusSquare.solveSpecifiedGame("a6 b1 B5 d1 E3 f2 F4", GLGeniusSquarePrinter())
            GeniusSquare.solveRandomGame(GLGeniusSquarePrinter())
            GeniusSquare.solveRandomGame(GLGeniusSquarePrinter(), false)
            GeniusSquare.solveRandomGame(GLGeniusSquarePrinter(), true, false)
            GeniusSquare.solveRandomGame(GLGeniusSquarePrinter(), false, false)
        }

        fun testWrongInputs() {
            try {
                GeniusSquare.solveSpecifiedGame("B0 D1 F4 D4 F1 D6 B1", GLGeniusSquarePrinter())
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
            try {
                GeniusSquare.solveSpecifiedGame("A5 F2 E4 C4 F1 B5 B1", GLGeniusSquarePrinter())
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
            try {
                GeniusSquare.solveSpecifiedGame("F2 A1 E4 C4 A6 A4", GLGeniusSquarePrinter())
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
            try {
                GeniusSquare.solveSpecifiedGame("A5 A1 DD C4 F1 A4 B3", GLGeniusSquarePrinter())
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
            try {
                GeniusSquare.solveSpecifiedGame("F2 D2 E6 B4 F1 F6 A22", GLGeniusSquarePrinter())
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
        }

        fun testAllGames() {
            GeniusSquare.solveAllGames(GLGeniusSquarePrinter(), printSolution = false)
        }

        fun testAllCreatedGame() {
            try {
                GeniusSquare.solveAllGamesWithSpecifiedDices(
                    listOf(
                        listOf(Pair('a', 6)),
                        listOf(Pair('b', 1)),
                        listOf(Pair('b', 5)),
                        listOf(Pair('d', 1)),
                        listOf(Pair('e', 3)),
                        listOf(Pair('f', 2)),
                        listOf(Pair('F', 4))
                    ),
                    GLGeniusSquarePrinter(), printSolution = false
                )
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
        }

        fun testCreateGame() {
            GeniusSquare.createNewGames()
        }

    }

}