package au.id.bjf.dlx.data;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Benchmark {

    private static int counter = 0;

    private static final String FILE = "matrices.txt";

    public static void readExactCoverProblemsFromFile() throws IOException {
        if (!new File(FILE).exists()) {
            return;
        }
        var reader = new Scanner(new InputStreamReader(new FileInputStream(FILE)));
        while (reader.hasNextLine()) {
            List<String[]> matrix = new ArrayList<>();
            var line = reader.nextLine();
            while (!line.isEmpty()) {
                matrix.add(line.split(" "));
                line = reader.nextLine();
            }
            var byteArray = convert(matrix);
            var timeBegin = System.currentTimeMillis();
            var columnObject = DLX.buildSparseMatrix(byteArray);
            DLX.solve(columnObject, true);
            var timeEnd = System.currentTimeMillis();
            counter++;
            System.out.println("" + counter + ". time = " + (timeEnd - timeBegin));
        }
    }

    private static byte[][] convert(List<String[]> matrix) {
        byte[][] byteArray = new byte[matrix.size()][matrix.get(0).length];
        for (int i = 0; i < matrix.size(); i++) {
            for (int j = 0; j < matrix.get(i).length; j++) {
                byteArray[i][j] = (byte) Integer.parseInt(matrix.get(i)[j]);
            }
        }
        return byteArray;
    }

    public static void main(String[] args) throws IOException {
        readExactCoverProblemsFromFile();
    }

}