/*
 * Decompiled with CFR 0.152.
 */
package gui.light_table;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import model.Light;

public class LightTableModel
extends AbstractTableModel {
    private List<Light> lights;
    private String[] colNames = new String[]{"Name", "Participation"};

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public int getRowCount() {
        return this.lights.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Light light = this.lights.get(row);
        switch (col) {
            case 0: {
                return light.getName();
            }
            case 1: {
                return light.getParticipation();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.lights == null) {
            return;
        }
        Light light = this.lights.get(row);
        switch (col) {
            case 1: {
                light.setParticipation((Boolean)value);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setData(List<Light> lights) {
        this.lights = lights;
    }

    public void clearData() {
        this.lights.removeAll(this.lights);
    }
}

