/*
 * Decompiled with CFR 0.152.
 */
package gui.results_table;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import model.Result;

public class ResultTableModel
extends AbstractTableModel {
    private List<Result> results;
    private String[] colNames = new String[]{"Name", "Minimum [%]", "Middle [%]", "Maximum [%]"};

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Result result = this.results.get(row);
        switch (col) {
            case 0: {
                return result.getName();
            }
            case 1: {
                return result.getMinimum();
            }
            case 2: {
                return result.getMiddle();
            }
            case 3: {
                return result.getMaximum();
            }
        }
        return null;
    }

    public void setResults(List<Result> results) {
        this.results = results;
    }

    public void clearResults() {
        this.results.removeAll(this.results);
    }
}

