/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class FontChooser
extends JDialog
implements ItemListener {
    public int result = -1;
    protected Font resultFont;
    protected String resultName;
    protected int resultSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected int zoom;
    protected String displayText = "Sample Text";
    protected String[] fontList;
    protected List fontNameChoice;
    protected List fontSizeChoice;
    JCheckBox bold;
    JCheckBox italic;
    protected JLabel zoomtext;
    protected JTextArea zoomarea;
    protected String[] fontSizes = new String[]{"5", "6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "36", "40", "46", "54", "60", "66", "72"};
    protected static final int DEFAULT_SIZE = 6;
    protected JLabel previewArea;

    public FontChooser(Frame frame, Font font, int n) {
        super(frame, "Scale&Font", true);
        int n2;
        this.resultFont = font;
        this.zoom = n;
        Container container = this.getContentPane();
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        container.add((Component)panel, "North");
        this.fontNameChoice = new List(8);
        panel.add(this.fontNameChoice);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontNameChoice.select(0);
        for (n2 = 0; n2 < this.fontList.length; ++n2) {
            this.fontNameChoice.add(this.fontList[n2]);
            if (!this.fontList[n2].startsWith(font.getName()) || !this.fontList[n2].endsWith(font.getName())) continue;
            this.fontNameChoice.select(n2);
        }
        this.fontNameChoice.setFont(font);
        this.fontNameChoice.addItemListener(this);
        this.fontSizeChoice = new List(8);
        panel.add(this.fontSizeChoice);
        this.fontSizeChoice.add(this.fontSizes[0]);
        this.fontSizeChoice.select(0);
        for (n2 = 1; n2 < this.fontSizes.length - 1; ++n2) {
            this.fontSizeChoice.add(this.fontSizes[n2]);
            if (Integer.parseInt(this.fontSizes[n2 + 1]) + Integer.parseInt(this.fontSizes[n2]) <= 2 * font.getSize() || Integer.parseInt(this.fontSizes[n2]) + Integer.parseInt(this.fontSizes[n2 - 1]) > 2 * font.getSize()) continue;
            this.fontSizeChoice.select(n2);
        }
        if (Integer.parseInt(this.fontSizes[this.fontSizes.length - 1]) < font.getSize()) {
            this.fontSizeChoice.select(this.fontSizes.length - 1);
        }
        this.fontSizeChoice.setFont(font);
        this.fontSizeChoice.addItemListener(this);
        Panel panel2 = new Panel();
        panel.add(panel2);
        panel2.setLayout(new GridLayout(0, 1));
        this.zoomtext = new JLabel("Scale%", 2);
        this.zoomtext.setFont(font);
        panel2.add(this.zoomtext);
        this.zoomarea = new JTextArea("" + this.zoom);
        this.zoomarea.setFont(font);
        panel2.add(this.zoomarea);
        if ((font.getStyle() & 1) != 0) {
            this.bold = new JCheckBox("Bold", true);
            panel2.add(this.bold);
        } else {
            this.bold = new JCheckBox("Bold", false);
            panel2.add(this.bold);
        }
        this.bold.setFont(font);
        if ((font.getStyle() & 2) != 0) {
            this.italic = new JCheckBox("Italic", true);
            panel2.add(this.italic);
        } else {
            this.italic = new JCheckBox("Italic", false);
            panel2.add(this.italic);
        }
        this.italic.setFont(font);
        this.bold.addItemListener(this);
        this.italic.addItemListener(this);
        Panel panel3 = new Panel();
        container.add((Component)panel3, "South");
        JButton jButton = new JButton("    OK    ");
        jButton.setFont(font);
        panel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.result = 0;
                FontChooser.this.previewFont();
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFont(font);
        panel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.resultFont = null;
                FontChooser.this.resultName = null;
                FontChooser.this.resultSize = 0;
                FontChooser.this.isBold = false;
                FontChooser.this.isItalic = false;
                FontChooser.this.result = 1;
                FontChooser.this.dispose();
                FontChooser.this.setVisible(false);
            }
        });
        this.previewArea = new JLabel(this.displayText, 0);
        this.previewArea.setSize(200, 50);
        container.add((Component)this.previewArea, "Center");
        Tools tools = new Tools();
        Tools.scaleCheckBoxIcon(this.bold);
        Tools.scaleCheckBoxIcon(this.italic);
        this.previewFont();
        this.pack();
    }

    protected void previewFont() {
        this.resultName = this.fontNameChoice.getSelectedItem();
        String string = this.fontSizeChoice.getSelectedItem();
        int n = Integer.parseInt(string);
        this.isBold = this.bold.isSelected();
        this.isItalic = this.italic.isSelected();
        int n2 = 0;
        if (this.isBold) {
            n2 = 1;
        }
        if (this.isItalic) {
            n2 |= 2;
        }
        this.resultFont = new Font(this.resultName, n2, n);
        this.previewArea.setFont(this.resultFont);
        this.pack();
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getSelectedFont() {
        return this.resultFont;
    }

    public int getZoom() {
        this.zoom = Integer.parseInt(this.zoomarea.getText());
        return this.zoom;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.previewFont();
    }
}

