/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class Plotter
extends Canvas {
    Spectrometer app;
    int sizeY = 500;
    int sizeX = 500;
    double cursorX = 0.0;
    double cursorY = 0.0;
    double rangeX = 0.0;
    double rangeY = 0.0;
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;
    double originX = 0.0;
    double originY = 0.0;
    Graphics2D g2;
    int MAXPIXELS = 3000;
    int numpoints = 0;
    double[] x = new double[this.MAXPIXELS];
    double[] y = new double[this.MAXPIXELS];

    Plotter(Spectrometer spectrometer, int n, int n2, int n3, int n4) {
        this.app = spectrometer;
        this.sizeX = n3;
        this.sizeY = n4;
        this.setBounds(n, n2, this.sizeX, this.sizeY);
        this.setBackground(Color.white);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        this.g2 = (Graphics2D)graphics;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.plot();
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d2;
        this.minY = d4;
        this.maxY = d3;
        this.rangeX = this.maxX - this.minX;
        this.rangeY = this.maxY - this.minY;
        this.originX = -this.minX * (double)this.sizeX / this.rangeX;
        this.originY = -this.minY * (double)this.sizeY / this.rangeY;
    }

    public void drawAxis() {
        this.g2.draw(new Line2D.Double(this.originX, 0.0, this.originX, this.sizeY));
        this.g2.draw(new Line2D.Double(0.0, this.originY, this.sizeX, this.originY));
    }

    public void drawGrid() {
        double d;
        this.g2.setColor(Color.gray);
        for (d = 0.0; d <= (double)this.sizeX; d += 20.0) {
            this.g2.draw(new Line2D.Double(d, 0.0, d, this.sizeY));
        }
        for (d = 0.0; d <= (double)this.sizeY; d += 20.0) {
            this.g2.draw(new Line2D.Double(0.0, d, this.sizeX, d));
        }
    }

    public void moveTo(double d, double d2) {
        this.cursorX = (d - this.minX) * (double)this.sizeX / this.rangeX;
        this.cursorY = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
    }

    public void lineTo(double d, double d2) {
        double d3 = (d - this.minX) * (double)this.sizeX / this.rangeX;
        double d4 = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
        this.g2.draw(new Line2D.Double(this.cursorX, this.cursorY, d3, d4));
        this.cursorX = d3;
        this.cursorY = d4;
    }

    public void drawPoint() {
        this.g2.draw(new Rectangle2D.Double(this.cursorX - 3.0, this.cursorY - 3.0, 6.0, 6.0));
    }

    public void setColor(Color color) {
        this.g2.setColor(color);
    }

    public void drawText(String string) {
        this.g2.drawString(string, (float)this.cursorX, (float)this.cursorY);
    }

    public void plot() {
        double d = 1.0E99;
        double d2 = -1.0E99;
        double d3 = 1.0E99;
        double d4 = -1.0E99;
        double d5 = 0.0;
        String string = this.app.programpath + "/spectrum.dat";
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            String string2;
            File file = new File(string);
            if (!file.exists()) {
                System.out.println("'" + string + "' file not found, no spectrum will be plotted.");
                return;
            }
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.numpoints = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (stringTokenizer.hasMoreTokens()) {
                    double d6;
                    this.x[this.numpoints] = Double.parseDouble(stringTokenizer.nextToken());
                    if (d > this.x[this.numpoints]) {
                        d = this.x[this.numpoints];
                    }
                    if (d2 < this.x[this.numpoints]) {
                        d2 = this.x[this.numpoints];
                    }
                    if (this.numpoints >= this.MAXPIXELS) {
                        System.out.println("Maximum number of points (MAXPIXELS) exceed in " + string);
                        return;
                    }
                    this.y[this.numpoints] = d6 = Double.parseDouble(stringTokenizer.nextToken());
                    if (d3 > this.y[this.numpoints]) {
                        d3 = this.y[this.numpoints];
                    }
                    if (d4 < this.y[this.numpoints]) {
                        d4 = this.y[this.numpoints];
                    }
                    d5 += d6;
                }
                ++this.numpoints;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setScale(d, d2, d3, d4);
        this.setColor(Color.black);
        this.moveTo(d2 - 200.0, d4 - 100.0);
        this.g2.drawString("Average: " + (int)(d5 / (double)this.numpoints) + "         Maximum: " + (int)d4, this.sizeX - 200, 20);
        this.setColor(Color.black);
        this.drawAxis();
        this.setColor(Color.red);
        this.moveTo(this.app.refline, d3);
        this.lineTo(this.app.refline, d4);
        this.setColor(Color.blue);
        this.moveTo(this.x[0], this.y[0]);
        for (int i = 0; i < this.numpoints; ++i) {
            this.lineTo(this.x[i], this.y[i]);
        }
        System.out.printf(this.numpoints + " spectrum points shown\n", new Object[0]);
    }
}

