/*
 * Decompiled with CFR 0.152.
 */
import com.oceanoptics.omnidriver.api.wrapper.Wrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class Spectrometer
extends JFrame
implements ActionListener,
Runnable {
    static Spectrometer okno;
    Font myFont;
    double zoom = 1.0;
    double fontrelativesize = 1.0;
    int winsizex = 700;
    int winsizey = 550;
    int borderx = 10;
    int bordery = 180;
    double refline = 550.0;
    double offset = 0.0;
    File programpath;
    String programpathname;
    JButton button1;
    JButton button2;
    JButton button3;
    JButton button4;
    JLabel label1;
    JLabel label2;
    JLabel label3;
    JTextField text1;
    JRadioButton radiobutton1;
    JRadioButton radiobutton2;
    JRadioButton radiobutton3;
    ButtonGroup buttongroup;
    Plotter plotter;
    JComboBox<String> combobox1;
    int nummodes = 15;
    String[] expo_name = new String[]{"3 ms", "5 ms", "10 ms", "20 ms", "50 ms", "100 ms", "200 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "20 s", "30 s", "50 s"};
    long[] expo_value = new long[]{3000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 30000000L, 50000000L};
    long expo_time = 3000L;
    int expo_index = 0;
    Sound sound;
    int mode = 0;
    Thread th;
    boolean thread_is_running;
    boolean thread_stop_required;

    public static void main(String[] stringArray) {
        try {
            System.setOut(new PrintStream(new File("logfile.txt")));
        }
        catch (IOException iOException) {
            System.out.println("File logfile.txt cannot be created...");
        }
        okno = new Spectrometer();
        okno.setVisible(true);
    }

    public Spectrometer() {
        super("Spectrometer");
        String string;
        BufferedReader bufferedReader;
        FileReader fileReader;
        File file;
        this.programpathname = Spectrometer.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.programpathname = this.programpathname.replace("/Spectrometer.jar", "");
        this.programpath = new File(this.programpathname);
        int n = (int)((double)this.winsizex * this.zoom);
        int n2 = (int)((double)this.winsizey * this.zoom);
        this.setSize(n, n2);
        this.addWindowListener(new WindowClosingAdapter(true));
        this.getContentPane().setLayout(null);
        String string2 = this.programpath + "/appsize.cfg";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            file = new File(string2);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            System.out.println("Reading 'appsize.cfg' file:");
            string = bufferedReader.readLine();
            String string3 = string.trim();
            System.out.println("Font name: " + string3);
            string = bufferedReader.readLine();
            int n3 = Integer.parseInt(string.trim());
            System.out.println("Font style: " + n3);
            string = bufferedReader.readLine();
            int n4 = Integer.parseInt(string.trim());
            System.out.println("Font size: " + n4);
            string = bufferedReader.readLine();
            this.zoom = (double)Integer.parseInt(string.trim()) / 100.0;
            System.out.println("Zoom: " + this.zoom);
            bufferedReader.close();
            this.myFont = new Font(string3, n3, n4);
            this.fontrelativesize = (double)n4 / this.zoom;
        }
        catch (IOException iOException) {
            this.myFont = new Font("default", 1, 11);
            this.zoom = 1.0;
            this.fontrelativesize = 11.0;
            System.out.println("File " + string2 + " not found, default font and size used.");
        }
        string2 = this.programpath + "/appmode.cfg";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            file = new File(string2);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            System.out.println("Reading 'appmode.cfg' file:");
            string = bufferedReader.readLine();
            this.mode = Integer.parseInt(string.trim());
            System.out.println("Measurement mode: " + this.mode);
            string = bufferedReader.readLine();
            this.expo_index = Integer.parseInt(string.trim());
            System.out.println("Exposure time: " + this.expo_name[this.expo_index]);
            this.expo_time = this.expo_value[this.expo_index];
            string = bufferedReader.readLine();
            this.refline = Double.parseDouble(string.trim());
            System.out.println("Reference line (nm): " + this.refline);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("File " + string2 + " not found, default parameters used.");
        }
        string2 = this.programpath + "/offset.cfg";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            file = new File(string2);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            System.out.println("Reading 'offset.cfg' file:");
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            this.offset = Double.parseDouble(string.trim());
            System.out.println("Wavelenght offset: " + this.offset);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("File " + string2 + " not found, no wavelength offset applied.");
        }
        this.button1 = new JButton("Tlacitko1");
        this.button1.setText("<HTML>Start measurement</HTML>");
        this.getContentPane().add(this.button1);
        this.button1.addActionListener(this);
        this.button1.setActionCommand("Start");
        this.button2 = new JButton("Tlacitko2");
        this.button2.setText("<HTML>Set application size...</HTML>");
        this.getContentPane().add(this.button2);
        this.button2.addActionListener(this);
        this.button2.setActionCommand("Font");
        this.label1 = new JLabel("Mode:");
        this.getContentPane().add(this.label1);
        this.radiobutton1 = new JRadioButton("<HTML>Find most intense spectrum (with dark spectrum substraction)</HTML>");
        this.getContentPane().add(this.radiobutton1);
        this.radiobutton2 = new JRadioButton("<HTML>Show current spectrum (with dark spectrum substraction)</HTML>");
        this.getContentPane().add(this.radiobutton2);
        this.radiobutton3 = new JRadioButton("<HTML>Long time averaged spectrum (no dark spectrum substraction)</HTML>");
        this.getContentPane().add(this.radiobutton3);
        this.buttongroup = new ButtonGroup();
        this.buttongroup.add(this.radiobutton1);
        this.buttongroup.add(this.radiobutton2);
        this.buttongroup.add(this.radiobutton3);
        this.label2 = new JLabel("Exposure time:");
        this.getContentPane().add(this.label2);
        this.combobox1 = new JComboBox();
        for (int i = 0; i < this.nummodes; ++i) {
            this.combobox1.addItem(this.expo_name[i]);
        }
        this.getContentPane().add(this.combobox1);
        this.combobox1.setSelectedIndex(this.expo_index);
        this.text1 = new JTextField();
        this.text1.setText(Double.toString(this.refline));
        this.text1.addActionListener(this);
        this.text1.setActionCommand("Wavel");
        this.getContentPane().add(this.text1);
        this.label3 = new JLabel("nm   reference line");
        this.getContentPane().add(this.label3);
        this.plotter = new Plotter(this, (int)(this.zoom * (double)this.borderx), (int)(this.zoom * (double)this.bordery), (int)(this.zoom * (double)(this.winsizex - 2 * this.borderx)), (int)(this.zoom * (double)(this.winsizey - this.bordery - this.borderx)));
        this.plotter.setBackground(Color.WHITE);
        this.getContentPane().add(this.plotter);
        this.setFont();
        this.resizeWindow();
        this.resizeApplication();
        this.setRadioButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Start")) {
            if (this.thread_is_running) {
                this.button1.setText("Finishing the measurement...");
                this.saveParam();
                this.thread_stop_required = true;
                return;
            }
            if (!this.thread_is_running) {
                this.button1.setText("Stop");
            }
            this.thread_stop_required = false;
            this.mode = this.getSelectedRadioButton();
            this.expo_index = this.combobox1.getSelectedIndex();
            this.expo_time = this.expo_value[this.expo_index];
            this.refline = Double.parseDouble(this.text1.getText());
            System.out.println("------------------------------------------------------------------------------");
            System.out.println("Saving the parameters (mode: " + this.mode + ", exposure time: " + this.expo_name[this.expo_index] + ")");
            this.saveParam();
            System.out.println("Starting the measurement");
            this.th = new Thread(this);
            this.th.start();
        }
        if (string.equals("Font")) {
            FontChooser fontChooser = new FontChooser((Frame)this, this.myFont, (int)(this.zoom * 100.0));
            fontChooser.setLocationRelativeTo(this);
            fontChooser.setVisible(true);
            Font font = fontChooser.getSelectedFont();
            if (fontChooser.result == 0) {
                this.mode = this.getSelectedRadioButton();
                this.myFont = font;
                this.zoom = (double)fontChooser.getZoom() / 100.0;
                this.fontrelativesize = (double)this.myFont.getSize() / this.zoom;
                this.setFont();
                System.out.println("New font selected: " + this.myFont);
                System.out.println("New zoom value: " + this.zoom * 100.0 + "%");
                this.resizeApplication();
                this.resizeWindow();
                this.saveSize();
                this.setRadioButtons();
            }
            fontChooser.dispose();
        }
        if (string.equals("Wavel")) {
            this.refline = Double.parseDouble(this.text1.getText());
            this.plotter.repaint();
        }
    }

    public void setRadioButtons() {
        this.buttongroup.clearSelection();
        switch (this.mode) {
            case 0: {
                this.radiobutton1.setSelected(true);
                break;
            }
            case 1: {
                this.radiobutton2.setSelected(true);
                break;
            }
            case 2: {
                this.radiobutton3.setSelected(true);
            }
        }
    }

    public int getSelectedRadioButton() {
        if (this.radiobutton1.isSelected()) {
            return 0;
        }
        if (this.radiobutton2.isSelected()) {
            return 1;
        }
        if (this.radiobutton3.isSelected()) {
            return 2;
        }
        return -1;
    }

    public void saveSize() {
        String string = this.programpath + "/appsize.cfg";
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(this.myFont.getName());
            bufferedWriter.newLine();
            bufferedWriter.write(this.myFont.getStyle() + "");
            bufferedWriter.newLine();
            bufferedWriter.write(this.myFont.getSize() + "");
            bufferedWriter.newLine();
            bufferedWriter.write((int)(100.0 * this.zoom) + "");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("File 'appsize.cfg' can not be created. New default font can not be stored.");
        }
    }

    public void saveParam() {
        String string = this.programpath + "/appmode.cfg";
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(this.mode + "");
            bufferedWriter.newLine();
            bufferedWriter.write(this.expo_index + "");
            bufferedWriter.newLine();
            bufferedWriter.write(this.refline + "");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("File 'appmode.cfg' can not be created. Parameters can not be stored.");
        }
    }

    public void setFont() {
        this.button1.setFont(this.myFont);
        this.button2.setFont(this.myFont);
        this.label1.setFont(this.myFont);
        this.label2.setFont(this.myFont);
        this.combobox1.setFont(this.myFont);
        this.radiobutton1.setFont(this.myFont);
        this.radiobutton2.setFont(this.myFont);
        this.radiobutton3.setFont(this.myFont);
    }

    public void resizeWindow() {
        this.setSize((int)((double)this.winsizex * this.zoom + (double)(2 * this.borderx)), (int)((double)this.winsizey * this.zoom + (double)(4 * this.borderx)));
    }

    public void resizeApplication() {
        int n = (int)((double)(this.winsizex - 2 * this.borderx) * this.zoom);
        int n2 = (int)((double)(this.winsizey - this.borderx - this.bordery) * this.zoom);
        this.plotter.sizeX = n;
        this.plotter.sizeY = n2;
        this.plotter.setBounds((int)((double)this.borderx * this.zoom), (int)((double)this.bordery * this.zoom), n, n2);
        UIManager.put("OptionPane.messageFont", this.myFont);
        UIManager.put("OptionPane.buttonFont", this.myFont);
        this.button1.setBounds((int)(450.0 * this.zoom), (int)(50.0 * this.zoom), (int)(220.0 * this.zoom), (int)(25.0 * this.zoom));
        this.button2.setBounds((int)(200.0 * this.zoom), (int)(125.0 * this.zoom), (int)(220.0 * this.zoom), (int)(25.0 * this.zoom));
        this.radiobutton1.setBounds((int)(10.0 * this.zoom), (int)(35.0 * this.zoom), (int)(415.0 * this.zoom), (int)(25.0 * this.zoom));
        this.radiobutton2.setBounds((int)(10.0 * this.zoom), (int)(55.0 * this.zoom), (int)(415.0 * this.zoom), (int)(25.0 * this.zoom));
        this.radiobutton3.setBounds((int)(10.0 * this.zoom), (int)(75.0 * this.zoom), (int)(415.0 * this.zoom), (int)(25.0 * this.zoom));
        this.label1.setBounds((int)(10.0 * this.zoom), (int)(15.0 * this.zoom), (int)(100.0 * this.zoom), (int)(25.0 * this.zoom));
        this.label2.setBounds((int)(10.0 * this.zoom), (int)(105.0 * this.zoom), (int)(100.0 * this.zoom), (int)(25.0 * this.zoom));
        this.combobox1.setBounds((int)(10.0 * this.zoom), (int)(125.0 * this.zoom), (int)(150.0 * this.zoom), (int)(25.0 * this.zoom));
        this.text1.setBounds((int)(10.0 * this.zoom), (int)(155.0 * this.zoom), (int)(50.0 * this.zoom), (int)(25.0 * this.zoom));
        this.label3.setBounds((int)(65.0 * this.zoom), (int)(155.0 * this.zoom), (int)(150.0 * this.zoom), (int)(25.0 * this.zoom));
        Tools tools = new Tools();
        this.buttongroup.clearSelection();
        Tools.scaleRadioButtonIcon(this.radiobutton1);
        Tools.scaleRadioButtonIcon(this.radiobutton2);
        Tools.scaleRadioButtonIcon(this.radiobutton3);
    }

    @Override
    public void run() {
        try {
            Path path;
            Path path2;
            String string;
            Date date;
            SimpleDateFormat simpleDateFormat;
            String string2;
            this.thread_is_running = true;
            if (!this.StartMeasurement()) {
                System.out.println("No spectrum to save is available.");
                this.thread_is_running = false;
                this.button1.setText("Start");
                return;
            }
            try {
                string2 = URLDecoder.decode(this.programpath + "/spectrum.dat", "UTF-8");
                simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
                date = new Date();
                string = URLDecoder.decode(this.programpath + "/spectrum_" + simpleDateFormat.format(date) + ".dat", "UTF-8");
                path2 = Paths.get(string2, new String[0]);
                path = Paths.get(string, new String[0]);
                System.out.println("Saving 'spectrum.dat' to '" + URLDecoder.decode("spectrum_" + simpleDateFormat.format(date) + ".dat", "UTF-8") + "'");
                try {
                    Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    System.out.println("Can't save '" + string2 + "' to '" + string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Problem with decoding the filename");
            }
            try {
                string2 = URLDecoder.decode(this.programpath + "/spectrum_cal.dat", "UTF-8");
                simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
                date = new Date();
                string = URLDecoder.decode(this.programpath + "/spectrum_" + simpleDateFormat.format(date) + "_cal.dat", "UTF-8");
                path2 = Paths.get(string2, new String[0]);
                path = Paths.get(string, new String[0]);
                System.out.println("Saving 'spectrum_cal.dat' to '" + URLDecoder.decode("spectrum_" + simpleDateFormat.format(date) + "_cal.dat", "UTF-8") + "'");
                try {
                    Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    System.out.println("Can't save '" + string2 + "' to '" + string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Problem with decoding the filename");
            }
            this.thread_is_running = false;
            this.button1.setText("Start");
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println("No sound device available.");
        }
    }

    public boolean StartMeasurement() throws LineUnavailableException {
        int n;
        double[] dArray;
        double d;
        Object object;
        int n2;
        Object object2;
        Reader reader;
        Wrapper wrapper = new Wrapper();
        int n3 = 4100;
        int n4 = 10;
        int n5 = 1;
        int n6 = 0;
        Sound.initialize(5000, 3, 1.0);
        int n7 = wrapper.openAllSpectrometers();
        if (n7 < 1) {
            System.out.println("There are no spectrometers attached to the computer");
            JOptionPane.showMessageDialog(this, "There are no spectrometers attached to the computer", "Warning", 1);
            return false;
        }
        String string = wrapper.getSerialNumber(0);
        System.out.println("Serial Number: " + string);
        int n8 = 0;
        int[] nArray = new int[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray3[i] = 0.0;
        }
        String string2 = this.programpath + "/hotpixels.cfg";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            File file = new File(string2);
            if (!file.exists()) {
                System.out.println("'" + string2 + "' file not found, no 'hot' pixels will be corrected.");
                n8 = 0;
            } else {
                FileReader fileReader = new FileReader(file);
                reader = new BufferedReader(fileReader);
                object2 = reader.readLine();
                int n9 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray[n2] = 0;
                }
                while ((object2 = reader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n2 >= n3) {
                            System.out.println("Maximum number of 'hot' pixels (MAXPIXELS) exceed in hotpixels.txt.");
                            return false;
                        }
                        nArray[n2] = 1;
                        ++n8;
                    }
                    ++n9;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.printf(n8 + " 'hot' pixels read\n", new Object[0]);
        int n10 = 0;
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = 1.0;
        }
        string2 = this.programpath + "/calibration.cfg";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            object = new File(string2);
            if (!((File)object).exists()) {
                System.out.println("'" + string2 + "' file not found, no correction will be made.");
            } else {
                reader = new FileReader((File)object);
                object2 = new BufferedReader(reader);
                String string3 = ((BufferedReader)object2).readLine();
                while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n2 >= n3) {
                            System.out.println("Maximum number of pixels (MAXPIXELS) exceed in calibration.txt.");
                            return false;
                        }
                        dArray2[n2] = d = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    ++n10;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.printf(n10 + " calibration coefficients read\n", new Object[0]);
        n4 = (int)this.expo_time;
        n5 = 1000 / (int)Math.sqrt(this.expo_time);
        if (n5 < 1) {
            n5 = 1;
        }
        wrapper.setIntegrationTime(0, n4);
        wrapper.setBoxcarWidth(0, n6);
        wrapper.setScansToAverage(0, n5);
        wrapper.setCorrectForDetectorNonlinearity(0, 1);
        wrapper.setCorrectForElectricalDark(0, 1);
        double[] dArray4 = wrapper.getWavelengths(0);
        int n11 = wrapper.getNumberOfPixels(0);
        object = new double[n11];
        double d2 = 0.0;
        if (this.mode == 0 || this.mode == 1) {
            System.out.println("Covering the spectrometer to get dark spectrum...");
            JOptionPane.showMessageDialog(this, "Cover the spectrometer and press OK to get dark spectrum...", "User input needed", 1);
            dArray = wrapper.getSpectrum(0);
            n11 = wrapper.getNumberOfPixels(0);
            boolean bl = wrapper.isSpectrumValid(0);
            if (!bl) {
                System.out.println("Spectrum is invalid!");
                return false;
            }
            for (n = 0; n < n11; ++n) {
                object[n] = dArray[n];
                d2 += dArray[n];
            }
            System.out.println("Darkspectrum taken, average = " + (d2 /= (double)n11));
        } else {
            for (n = 0; n < n11; ++n) {
                object[n] = 0.0;
            }
        }
        System.out.println("Uncovering the spectrometer to get spectrum...");
        JOptionPane.showMessageDialog(this, "Uncover the spectrometer and press OK to get spectrum...", "User input needed", 1);
        string2 = this.programpath + "/spectrum.dat";
        String string4 = this.programpath + "/spectrum_cal.dat";
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
            string4 = URLDecoder.decode(string4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        System.out.println("Aquired spectra (average value):");
        int n12 = 0;
        double d3 = 0.0;
        d = 0.0;
        while (!this.thread_stop_required) {
            int n13;
            dArray = wrapper.getSpectrum(0);
            n11 = wrapper.getNumberOfPixels(0);
            boolean bl = wrapper.isSpectrumValid(0);
            if (!bl) {
                System.out.println("Spectrum is invalid!");
                continue;
            }
            for (n13 = 0; n13 < n11; ++n13) {
                d3 += dArray[n13];
            }
            d3 /= (double)n11;
            if ((d3 -= d2) < d && this.mode == 0) continue;
            d = d3;
            System.out.println(d);
            if (this.mode == 2) {
                for (n13 = 0; n13 < n11; ++n13) {
                    dArray3[n13] = (dArray3[n13] * (double)n12 + dArray[n13]) / (double)(n12 + 1);
                }
                ++n12;
            }
            if (this.mode != 1) {
                Spectrometer spectrometer = this;
                spectrometer.sound.tone();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                File file = new File(string2);
                FileWriter fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                File file2 = new File(string4);
                FileWriter fileWriter2 = new FileWriter(file2);
                BufferedWriter bufferedWriter2 = new BufferedWriter(fileWriter2);
                for (int i = 0; i < n11; ++i) {
                    double d4;
                    double d5;
                    if (this.mode == 2) {
                        d5 = this.GetValidValue(dArray3, nArray, null, i, n11);
                        d4 = this.GetValidValue(dArray3, nArray, dArray2, i, n11);
                    } else {
                        d5 = this.GetValidValue(dArray, nArray, null, i, n11) - this.GetValidValue((double[])object, nArray, null, i, n11);
                        d4 = this.GetValidValue(dArray, nArray, dArray2, i, n11) - this.GetValidValue((double[])object, nArray, dArray2, i, n11);
                    }
                    bufferedWriter.write(dArray4[i] + "\t" + d5);
                    bufferedWriter2.write(dArray4[i] + this.offset + "\t" + d4);
                    bufferedWriter.newLine();
                    bufferedWriter2.newLine();
                }
                bufferedWriter.close();
                bufferedWriter2.close();
                this.plotter.repaint();
            }
            catch (IOException iOException) {
                System.out.printf("Can't write into '" + string2 + "'/'" + string4 + "' file", new Object[0]);
            }
        }
        if (this.mode == 0) {
            System.out.println("Maximum found: " + d);
        }
        if (this.mode == 2) {
            System.out.println("Number of averaged spectra: " + n12);
        }
        return true;
    }

    double GetValidValue(double[] dArray, int[] nArray, double[] dArray2, int n, int n2) {
        int n3;
        if (nArray[n] == 0) {
            if (dArray2 == null) {
                return dArray[n];
            }
            return dArray[n] * dArray2[n];
        }
        double d = dArray[0];
        double d2 = dArray[n2 - 1];
        for (n3 = n - 1; n3 >= 0; --n3) {
            if (nArray[n3] != 0) continue;
            d = dArray[n3];
            break;
        }
        for (n3 = n + 1; n3 < n2; ++n3) {
            if (nArray[n3] != 0) continue;
            d2 = dArray[n3];
            break;
        }
        if (dArray2 == null) {
            return (d + d2) / 2.0;
        }
        return (d + d2) / 2.0 * dArray2[n];
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1) {
            if (itemEvent.getItem() == this.radiobutton1) {
                this.mode = 0;
            }
            if (itemEvent.getItem() == this.radiobutton2) {
                this.mode = 1;
            }
            if (itemEvent.getItem() == this.radiobutton3) {
                this.mode = 2;
            }
        }
        if (n == 2) {
            // empty if block
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }
}

