package Datab.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import Datab.DbContext;
import Datab.getset.*;
/**
 * Tomáš Maťko
 */
public class DeleteUser {
    private static final DeleteUser INSTANCE = new DeleteUser();

    public static DeleteUser getInstance() {
        return INSTANCE;
    }

    public boolean delete(String log) throws SQLException, IOException {
        Users u = FindUser.getInstance().findByLogin(log);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try{

        if (u == null) {
            System.out.println("Uzivatel so zadanym loginom neexistuje");
        } else {
            System.out.print("Zadajte Váše Heslo: ");
            String pswd = br.readLine();

            if(u.getPasswd().equals(pswd)){
                List<Ticket> tickets= FindTicket.getInstance().findAllUser(u.getId());
                for(Ticket t:tickets){
                    t.delete();
                }
                u.delete();
                System.out.print("Váš účet bol vymazaný");
            }
            else{
                System.out.println("Účet nebol vymazaný, pravdepodobne ste zadali zlé heslo");

            }

        }
            DbContext.getConnection().commit();
            return true;
        } catch (SQLException e) {
            DbContext.getConnection().rollback();
            System.out.println("Účet nebol vymazaný SQL ERROR : ");
            System.out.println(e.getErrorCode());
            throw e;
        } finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }
}