package Datab.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import Datab.DbContext;
import Datab.getset.*;
/**
 * Tomáš Maťko
 */
public class TicketDel {
    private static final TicketDel INSTANCE = new TicketDel();

    public static TicketDel getInstance() {
        return INSTANCE;
    }

    public boolean delete(Integer id, Integer idTiketu) throws SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {

            Ticket t = FindTicket.getInstance().findById(idTiketu);

            if (t == null) {
                System.out.println("Taka udalost v tikete neexistuje");
            } else {
                t.delete();

                System.out.println("Udalost bola uspesne odstranena z tiketu");
            }


            DbContext.getConnection().commit();
            return true;
        } catch (SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        } finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }
}