
package Datab.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;

import Datab.DbContext;
import Datab.getset.Bets;
import Datab.getset.FindBets;
import Datab.getset.*;

/**
 * Tomáš Maťko
 */
public class TicketInsert {
    private static final TicketInsert INSTANCE = new TicketInsert();

    public static TicketInsert getInstance() {
        return INSTANCE;
    }

    public boolean insert(int id_bet, Integer bet, int id_user, int TicketId) throws TicketException, SQLException {
        if (bet == null || bet > 4 || FindGoals.getInstance().findByBetIdBoolean(id_bet) && bet ==0 || FindWin.getInstance().findByBetIdBoolean(id_bet) && bet > 2) {
            System.out.println("Zlý Tip, Skús znova");
            return false;
        }
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Bets udalost = FindBets.getInstance().findByIdAkt(id_bet);
            if (udalost == null) {
                throw new TicketException("Taka stavka neexistuje alebo nieje aktualna");
            }

            Ticket ticket = new Ticket();

            Users user = FindUser.getInstance().findById(id_user);
            if (user == null) {
                throw new TicketException("Taky uzivatel neexistuje");
            }
            if(FindTicket.getInstance().findBet(id_bet,id_user)){
                System.out.println("Udalost nebola pridana lebo uz je na tikete");
                return false;
            }


            ticket.setUser(id_user);
            ticket.setBetId(id_bet);
            ticket.setTip(bet);
            ticket.setAmount((double) 0);
            ticket.setTicketId(user.getTicketAmount());
            ticket.setProgress("o");
            ticket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
            ticket.insert();
            DbContext.getConnection().commit();

            return true;
        } catch(SQLException | TicketException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
            DbContext.getConnection().setAutoCommit(true);
        }
    }

}
