package Datab.getset;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
/**
 * Tomáš Maťko
 */
public class Bookmakers extends BaseGateway {

    private Integer id;
    private String name;
    private String surname;
    private String login;
    private String passwd;
    private String email;

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }

    public String getName() { return name; }
    public void setName(String name) { this.name = name; }

    public String getSurname() { return surname; }
    public void setSurname(String surname) { this.surname = surname; }

    public String getLogin() { return login; }
    public void setLogin(String login) { this.login = login; }

    public String getPasswd() { return passwd; }
    public void setPasswd(String passwd) { this.passwd = passwd; }

    public String getEmail() { return email; }
    public void setEmail(String email) { this.email = email; }




    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO bookmakeri (meno, priezvisko, login, heslo,email) VALUES (?,?,?,?,?)");
    }



    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setString(2, surname);
        s.setString(4, login);
        s.setString(5, passwd);
        s.setString(6,email);


    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        update("UPDATE bookmakeri SET meno = ?, priezvisko = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setString(2, surname);


    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM bookmakeri WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
}


