
package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
/**
 * Tomáš Maťko
 */
public class FindBookmakers extends BaseFinder<Bookmakers> {

    private static final FindBookmakers INSTANCE = new FindBookmakers();

    public static FindBookmakers getInstance() { return INSTANCE; }

    private FindBookmakers() { }

    public Bookmakers findById(int id) throws SQLException {
        return findByInt("SELECT * FROM bookmakeri WHERE id = ?", id);
    }

    public Bookmakers findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM bookmakeri WHERE login = ?", login);
    }

    public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM bookmakeri WHERE login = ?", login).equals(null)) return false;
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }
    }

    public List<Bookmakers> findAll() throws SQLException {
        return findAll("SELECT * FROM bookmakeri");
    }


    @Override
    protected Bookmakers load(ResultSet r) throws SQLException {
        Bookmakers c = new Bookmakers();

        c.setId(r.getInt("id"));
        c.setName(r.getString("meno"));
        c.setLogin(r.getString("login"));
        c.setPasswd(r.getString("heslo"));
        c.setSurname(r.getString("priezvisko"));
        c.setEmail(r.getString("email"));
        return c;
    }

}
