package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * Tomáš Maťko
 */
public class FindGoals extends BaseFinder<Goals>{
    private static final FindGoals INSTANCE = new FindGoals();
    
    public static FindGoals getInstance() { return INSTANCE; }
    
    private FindGoals() { }

    public List<Goals> findAllNull() throws SQLException {
        return findAll("SELECT * FROM goly WHERE vyhra IS NULL");
    }

    public Goals findById(int id) throws SQLException {
        return findByInt("SELECT * FROM goly WHERE id = ?", id);
    }
    
    public Goals findByBetId(int id) throws SQLException {
        return findByInt("SELECT * FROM goly WHERE id_stavky = ?", id);
    }
    
     public boolean findByBetIdBoolean(int id) {
        try {
            if(!findByInt("SELECT * FROM goly WHERE id_stavky = ?", id).equals(null)){
                return true;
            }
            else{
                return false;
            }

        } catch (SQLException | NullPointerException ex) {

            return false;
        }    }

    public List<Goals> findAll() throws SQLException {
        return findAll("SELECT * FROM goly");
    }
   
    @Override
    protected Goals load(ResultSet r) throws SQLException {
        Goals c = new Goals();

        c.setId(r.getInt("id"));
        c.setBetId(r.getInt("id_stavky"));
        c.setName1(r.getString("nazov1"));
        c.setName2(r.getString("nazov2"));
        c.set01(r.getDouble("golov_01"));
        c.set23(r.getDouble("golov_23"));
        c.set45(r.getDouble("golov_45"));
        c.set6(r.getDouble("nad5_golov"));
        c.setWin(r.getInt("vyhra"));
        return c;
    }
}
