
package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
/**
 * Tomáš Maťko
 */
public class FindOffice extends BaseFinder<Office> {
    
    private static final FindOffice INSTANCE = new FindOffice();
    
    public static FindOffice getInstance() { return INSTANCE; }
    
    private FindOffice() { }
		
    public Office findById(int id) throws SQLException {
        return findByInt("SELECT * FROM kancelaria WHERE id = ?", id);
    }
    
    public Office findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM kancelaria WHERE login = ?", login);
    }
    
    public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM kancelaria WHERE login = ?", login).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }

    public List<Office> findAll() throws SQLException {
        return findAll("SELECT * FROM kancelaria");
    }

    @Override
    protected Office load(ResultSet r) throws SQLException {
        Office c = new Office();

        c.setId(r.getInt("id"));
        c.setLogin(r.getString("login"));
        c.setPasswd(r.getString("heslo"));
        c.setKredit(r.getInt("kredit"));

        return c;
    }
}