
package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * Tomáš Maťko
 */
public class FindTicket extends BaseFinder<Ticket> {
    
    private static final FindTicket INSTANCE = new FindTicket();
    
    public static FindTicket getInstance() { return INSTANCE; }
    
    private FindTicket() { }
    
    public Ticket findById(int id) throws SQLException {
        return findByInt("SELECT * FROM tikety WHERE id = ?", id);
    }
    
    public boolean findBet(int id_bet, int id_user) throws SQLException {
        if(findByInts("SELECT * FROM tikety WHERE id_stavky = ? and id_uzivatela=?", id_bet, id_user) == null){
            return false;
        }
        return true;
    }
    
    public List<Ticket> FindAllZ() throws SQLException {
        return findAll("SELECT * FROM tikety WHERE stav = 'z'");
    }
     public List<Ticket> findZ(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tikety WHERE stav = 'z' and id_uzivatela = ?", id); //otvorena = otvoreny,p=podany,z = zatvoreny
    }
    public List<Ticket> findO(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tikety WHERE stav = 'o' and id_uzivatela = ?", id);
    }
    public List<Ticket> findP(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tikety WHERE stav = 'p' and id_uzivatela = ?", id);
    }
    public List<Ticket> findByBetId(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tikety WHERE id_stavky = ?", id);
    }
    
    public List<Ticket> findByUserIdTicketIdP(Integer id, Integer idTiketu) throws SQLException {
        return findAllByInts("SELECT * FROM tikety WHERE stav = 'p' and id_uzivatela = ? and idTiketu=?", id, idTiketu);
    }
    public List<Ticket> findByUserIdTicketIdZ(Integer id, Integer idTiketu) throws SQLException {
        return findAllByInts("SELECT * FROM tikety WHERE stav = 'z' and id_uzivatela = ? and idTiketu=?", id, idTiketu);
    }

    public List<Ticket> findAllUser(int id) throws SQLException {
        return findAllByInt("SELECT * FROM tikety WHERE stav = 'z' and  id_uzivatela=?",id);
    }

    @Override
    protected Ticket load(ResultSet r) throws SQLException {
        Ticket k = new Ticket();

        k.setId(r.getInt("id"));
        k.setUser(r.getInt("id_uzivatela"));
        k.setAmount(r.getDouble("suma"));
        k.setProgress(r.getString("stav"));
        k.setTip(r.getInt("tip"));
        k.setTicketId(r.getInt("idTiketu"));
        k.setBetId(r.getInt("id_stavky"));
        k.setDate(r.getDate("datum"));
        k.setWin(r.getBoolean("vyherny"));
        return k;
    }

}