package Datab.getset;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
/**
 * Tomáš Maťko
 */
public class Office extends BaseGateway {
	
    private Integer id;
    private String login;
    private String heslo;
    private String name;
    private String surname;
    private String email;
    private double kredit;

    public double getKredit() { return kredit; }
    public void setKredit(double kredit) { this.kredit = kredit; }

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }


    public String getLogin() { return login; }
    public void setLogin(String login) { this.login = login; }

    public String getPasswd() { return heslo; }
    public void setPasswd(String heslo) { this.heslo = heslo; }


    
    
    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO kancelaria (login, heslo,kredit) VALUES (?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, login);
        s.setString(2, heslo);
        s.setDouble(3, kredit);
 
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE kancelaria SET kredit = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setDouble(1, kredit);
        s.setInt(2, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM kancelaria WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
}
