package Datab.getset;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
/**
 * Tomáš Maťko
 */
public class Users extends BaseGateway {
	
    private Integer id;
    private String name;
    private String surname;
    private String login;
    private String passwd;
    private String email;
    private double money;
    private boolean bookmaker;
    private Integer number;

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }	
    
    public String getName() { return name; }
    public void setName(String name) { this.name = name; }

    public String getSurname() { return surname; }
    public void setSurname(String surname) { this.surname = surname; }

    public String getLogin() { return login; }
    public void setLogin(String login) { this.login = login; }
    
    public String getPasswd() { return passwd; }
    public void setPasswd(String passwd) { this.passwd = passwd; }
    
    public String getEmail() { return email; }
    public void setEmail(String email) { this.email = email; }

    public double getMoney() { return money; }
    public void setMoney(double money) { this.money = money; }

    public Integer getTicketAmount(){return number;}
    public void setTicketAmount(Integer number){this.number = number;}


    
    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO uzivatelia (meno, priezvisko, email,login, heslo, kredit,pocetTiketov) VALUES (?,?,?,?,?,?,?)");
    }
    


    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setString(2, surname);
        s.setString(3, email);
        s.setString(4, login);
        s.setString(5, passwd);
        s.setDouble(6, money);
        s.setInt(7,number);
 
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE uzivatelia SET meno = ?, priezvisko = ?, email = ?, kredit = ?,pocetTiketov = ? WHERE id = ?");
    }
    
    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setString(2, surname);
        s.setString(3, email);
        s.setDouble(4, money);
        s.setInt(5,number);
        s.setInt(6, id);

        
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }
        delete("DELETE FROM uzivatelia WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
}
	

