package Datab.ui;


import Datab.actions.DeleteUser;
import Datab.actions.TicketException;
import Datab.getset.*;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Tomáš Maťko
 */
public class Login extends Menu {

    @Override
        public void print() {
            System.out.println("**************Login***************");
            System.out.println("* 1. Prihlasenie                 *");
            System.out.println("* 2. Registracia                 *");
            System.out.println("* 3. Zmazanie účtu               *");
            System.out.println("* 4. Zamestnanecka zona          *");
            System.out.println("**********************************");
        }

        @Override
        public void handle(String option) {
            try {
                switch (option) {
                    case "1":   Login(); break;
                    case "2":   Registration(); break;
                    case "3":   Delete(); break;
                    case "4":   SystemLogin();break;
                    default:    System.out.println("Unknown option"); break;
                }
            }
            catch (IOException | SQLException | ParseException ex) {
                System.out.println(ex.getMessage());
            }
        }


        private void Login()  {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Zadaj login: ");
                String log = br.readLine();


                Users z = FindUser.getInstance().findByLogin(log);
                if (z == null){
                    System.out.println("Zle Meno");
                }
                else{
                    System.out.print("zadaj heslo: ");
                    String heslo = br.readLine();
                    if(FindUser.getInstance().findByLoginBool(log) && !z.getPasswd().equals(heslo)){
                        System.out.println("nespravne heslo");
                    }
                    else{
                       if (FindUser.getInstance().findByLoginBool(log)){
                            System.out.println("Vitajte " + z.getName());
                            MainMenu menu = new MainMenu(z.getId());
                            update(z.getId());
                            menu.run();

                        }
                    }
                }
            } catch (SQLException | IOException ex ) {
                ex.getMessage();
            }
        }
        private void Registration() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Users c = new Users();

        System.out.print("Zadaj login: ");
        String log = br.readLine();
        if (FindUser.getInstance().findByLogin(log) != null){
            System.out.print("Login je obsadený");
        }
        else{
            c.setLogin(log);
            System.out.print("Zadaj heslo: ");
            c.setPasswd(br.readLine());
            System.out.print("Zadaj meno: ");
            c.setName(br.readLine());
            System.out.print("Zadaj priezvisko: ");
            c.setSurname(br.readLine());
            System.out.print("Zadaj email: ");
            c.setEmail(br.readLine());
            c.setTicketAmount(1);
            c.setMoney(0);
            c.insert();
            System.out.println("Ste úspešne registrovaný!");
            System.out.print("Môžete sa prihlásiť");
            }
        }
        private void Delete() throws IOException, SQLException, ParseException {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

            System.out.print("Zadajte Váš Login: ");
            String log = br.readLine();
            DeleteUser.getInstance().delete(log);

        }
        private void SystemLogin(){
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Zadaj login: ");
                String log = br.readLine();


                Office z = FindOffice.getInstance().findByLogin(log);
                Bookmakers b = FindBookmakers.getInstance().findByLogin(log);
                if (z == null && b==null){
                    System.out.println("Zle Meno");
                }
                else{
                    System.out.print("zadaj heslo: ");
                    String heslo = br.readLine();
                    if(FindOffice.getInstance().findByLoginBool(log) && !z.getPasswd().equals(heslo)){
                        System.out.println("Nespravne heslo");
                    }
                    if(FindBookmakers.getInstance().findByLoginBool(log) && !b.getPasswd().equals(heslo)){
                        System.out.println("Nespravne heslo");
                    }
                    else{
                        if (FindBookmakers.getInstance().findByLoginBool(log)){
                            System.out.print("Vitaj Bookmaker " + b.getName());
                            BookmakerMenu menu = new BookmakerMenu(b.getId());
                            menu.run();

                        }
                        if (FindOffice.getInstance().findByLoginBool(log)){
                            OfficeMenu menu = new OfficeMenu(z.getId());
                            menu.run();

                        }
                    }
                }
            } catch (SQLException | IOException ex ) {
                ex.getMessage();
            }
        }
        private void update(Integer UserId) {
        try {

            for (int IdTiketu = 1; IdTiketu < FindUser.getInstance().findById(UserId).getTicketAmount(); IdTiketu++) {
                boolean win=false;
                int counter=0;
                int wcounter=0;
                double kurz = 1;
                double suma = 0;

                for (Ticket tiket : FindTicket.getInstance().findByUserIdTicketIdP(UserId, IdTiketu)) {
                    if (FindGoals.getInstance().findByBetIdBoolean(tiket.getBetId())) {
                        Goals g = FindGoals.getInstance().findByBetId(tiket.getBetId());
                        if (g.getWin() == tiket.getTip()) {
                            tiket.setWin(true);
                            tiket.setProgress("z");
                            tiket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
                            tiket.update();
                            wcounter++;
                            win=true;
                        } else {
                            tiket.setWin(false);
                            tiket.setProgress("z");
                            tiket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
                            tiket.update();
                        }
                    } else {
                        if (FindWin.getInstance().findByBetIdBoolean(tiket.getBetId())) {
                            Win w = FindWin.getInstance().findByBetId(tiket.getBetId());
                            if (w.getWin() == tiket.getTip()) {
                                tiket.setWin(true);
                                tiket.setProgress("z");
                                tiket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
                                tiket.update();
                                wcounter++;
                                win=true;
                            } else {
                                tiket.setWin(false);
                                tiket.setProgress("z");
                                tiket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
                                tiket.update();
                            }
                        }
                    }
                    counter++;
                    kurz *= tiket.getRate();
                    suma = tiket.getAmount();
                }
                if (counter==wcounter && win==true) {
                    System.out.println("Od posledného prihlásenia vám vyšiel tiket v sume " + suma * kurz + "€");
                    Users u = FindUser.getInstance().findById(UserId);
                    u.setMoney(u.getMoney() + suma * kurz);
                    u.update();
                } else {
                    Office k = FindOffice.getInstance().findById(1);
                    k.setKredit(k.getKredit() - suma * kurz);
                    k.update();
                }
            }

        } catch (SQLException ex) {
            System.out.println("taky tiket nie je");
        }
    }
}

