package Datab.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import Datab.getset.*;
import Datab.actions.*;
/**
 * Tomáš Maťko
 */
public class MainMenu extends Menu {

    private final Integer id;


    MainMenu(Integer id) {
        this.id = id;
    }


    @Override
    public void print() {
        System.out.println("****************Main Menu****************");
        System.out.println("* 1. Zobraziť informácie o mne          *");
        System.out.println("* 2. Správa financii                    *");
        System.out.println("* 3. Aktuálne dostupné stávky na výhru  *");
        System.out.println("* 4. Aktuálne dostupné stávky na góly   *");
        System.out.println("* 5. Pridanie stavky na tiket           *");
        System.out.println("* 6. Odstránenie stavky z tiketu        *");
        System.out.println("* 7. Zobrazenie tiketu                  *");
        System.out.println("* 8. Potrvdenie tiketu                  *");
        System.out.println("* 9. Moje Vyhodnotene Tikety            *");
        System.out.println("* 10.Moje Podane Tikety                 *");
        System.out.println("* 11.Statistika uspesnosti              *");
        System.out.println("* 12.Odhlásenie sa                      *");
        System.out.println("*****************************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   info(); break;
                case "2":   moneyStuff(); break;
                case "3":   PossibleBetsW(); break;
                case "4":   PossibleBetsG(); break;
                case "5":   newBet(); break;
                case "6":   deleteBet(); break;
                case "7":   showTicket();break;
                case "8":   acceptTicket(); break;
                case "9":   myTicketsZ();break;
                case "10":  myTicketsP();break;
                case "11":  SuccessRate();break;
                case "12":  exit(); break;
                default:    System.out.println("Skús znovu"); break;
            }
        } catch(IOException | SQLException e ) {
            throw new RuntimeException(e);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        } catch (TicketException e) {
            throw new RuntimeException(e);
        }
    }
    private void info() throws SQLException {
            System.out.println("Id:                     " + FindUser.getInstance().findById(id).getId());
            System.out.println("Meno:                   " + FindUser.getInstance().findById(id).getName());
            System.out.println("Priezvisko:             " + FindUser.getInstance().findById(id).getSurname());
            System.out.println("Email:                  " + FindUser.getInstance().findById(id).getEmail());
            System.out.println("Počet podaných tiketov: "+ (FindUser.getInstance().findById(id).getTicketAmount()-1));
    }
    private void moneyStuff(){
        MoneyMenu menu = new MoneyMenu(this.id);
        try {
            menu.run();
        } catch (IOException e) {
            System.out.println("Nieco sa pokazilo");
        }
    }
    private void PossibleBetsW() throws SQLException {
        try {
            Iterator pom = FindBets.getInstance().findNow().iterator();
            Integer counter = 0;
            System.out.println("Stávky na výhry: -------------------------------------------------------------------");

            while (pom.hasNext()) {

                Bets stavky = (Bets) pom.next();
                if (stavky == null) {
                    throw new NullPointerException("Stala sa chyba");
                }
                Integer BetId = stavky.getId();
                if (FindWin.getInstance().findByBetIdBoolean(BetId)) {
                    counter++;
                    System.out.println(counter + ".");
                    System.out.println("Identifikátor stávky:        " + BetId);
                    System.out.println("Stávka otvorená do:          " + stavky.getUntil());
                }

                if (FindWin.getInstance().findByBetIdBoolean(BetId)) {
                    if (BetId < 1) {
                        throw new NullPointerException("Id stávky nesmie byt null");
                    }
                    Win v = FindWin.getInstance().findByBetId(BetId);
                    System.out.println("Tip stávky: Výhra");
                    System.out.println("Tip 1 -> " + v.getName1() + "    kurz: " + v.getTeam1());
                    System.out.println("Tip 2 -> " + v.getName2() + "    kurz: " + v.getTeam2());
                    System.out.println("Tip 0: Remíza     kurz: " + v.getDraw());
                    System.out.println();
                }
            }
        } catch (SQLException var3) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }
    private void PossibleBetsG() {
        try {
            Iterator pom = FindBets.getInstance().findNow().iterator();
            Integer counter=0;
            System.out.println("Stávky na góly: -------------------------------------------------------------------");
            while(pom.hasNext()) {

                Bets stavky = (Bets)pom.next();
                if (stavky == null) {
                    throw new NullPointerException("Stala sa chyba");
                }
                Integer BetId = stavky.getId();
                if (FindGoals.getInstance().findByBetIdBoolean(BetId)){
                    counter++;
                    System.out.println(counter+".");
                    System.out.println("Identifikátor stávky:        " + BetId);
                    System.out.println("Stávka otvorená do:          "+stavky.getUntil());
                }

                if (FindGoals.getInstance().findByBetIdBoolean(BetId)) {
                    if (BetId <1) {
                        throw new NullPointerException("Id stávky nesmie byt null");
                    }
                    Goals g = FindGoals.getInstance().findByBetId(BetId);

                    System.out.println("Tip stávky: Počet gólov v zápase " + g.getName1() + " proti " + g.getName2() );
                    System.out.print("Tip 1 -> 0-1 Gól :     ");
                    System.out.println(g.get01());
                    System.out.print("Tip 2 -> 2-3 Góly :    ");
                    System.out.println(g.get23());
                    System.out.print("Tip 3 -> 4-5 Góly :    ");
                    System.out.println(g.get45());
                    System.out.print("Tip 4 -> Nad 5 Gólov :    ");
                    System.out.println(g.get6());
                    System.out.println();
                }
            }
        } catch (SQLException var3) {
            System.out.println("Nenasla sa ziadna udalost");
        }

    }
    private void newBet() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte id spomedzi existujúcich stávok: ");
        Integer id = Integer.parseInt(br.readLine());
        System.out.print("Zadajte tip na danú stávku: ");
        Integer bet = Integer.parseInt(br.readLine());
        boolean rest = false;
        try {
            Users user = FindUser.getInstance().findById(this.id);
            rest = TicketInsert.getInstance().insert(id, bet, user.getId(), user.getTicketAmount());
        } catch (TicketException e) {
            System.out.println(e.getMessage());
        }
        if(rest){
            System.out.println("Udalosť bola úspešne pridaná na Tiket. Teraz môžete pridať na tiket dalšie udalosti a vytvoriť tým akumulovanú stávku alebo potvrdiť a zaplatiť tiket.");

        }
    }
    private void deleteBet()  throws IOException, SQLException,ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.print("Zadajte id z tiketu: ");
        int idTiketu = Integer.parseInt(br.readLine());

        TicketDel.getInstance().delete(id,idTiketu);


    }
    private void acceptTicket() throws IOException, SQLException, ParseException, TicketException {
        System.out.print("Zadajte sumu za ktorú chcete podať tento tiket: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        double suma = (double) Integer.parseInt(br.readLine());
        boolean res = true;
        Integer counter = 0;
        Integer draws = 0;
        double rate = 1.0D;
        if (FindUser.getInstance().findById(this.id).getMoney() - suma >= 0) {
            Integer cislo = FindUser.getInstance().findById(this.id).getTicketAmount();
            Users uzivatel = new Users();
            uzivatel.setId(this.id);
            uzivatel.setName(FindUser.getInstance().findById(this.id).getName());
            uzivatel.setSurname(FindUser.getInstance().findById(this.id).getSurname());
            uzivatel.setEmail(FindUser.getInstance().findById(this.id).getEmail());
            uzivatel.setMoney(FindUser.getInstance().findById(this.id).getMoney() - suma);
            uzivatel.setTicketAmount(FindUser.getInstance().findById(this.id).getTicketAmount()+1);
            uzivatel.update();
            Office k = new Office();
            k.setId(1);
            k.setKredit(FindOffice.getInstance().findById(1).getKredit() + suma);
            k.update();
            Iterator pom = FindTicket.getInstance().findO(this.id).iterator();
            while(pom.hasNext()) {
                Ticket tiket = (Ticket)pom.next();
                counter = counter + 1;
                rate *= tiket.getRate();
                Integer tiketId = tiket.getId();
                Integer BetId = tiket.getBetId();
                TicketAccept.getInstance().potvrd(tiketId, suma, cislo, BetId);
                if (tiket.getTip() == 0) {
                    draws = draws + 1;
                }
            }

            if (counter == 0) {
                System.out.println("Tiket je prázdny");
                res = false;
                return;
            }

            if (counter != 0 && rate == 0.0D) {
                System.out.println("Nepodarilo sa získať kurzy");
                res = false;
            }
            if(rate != 1.0){
                System.out.println("Celkový kurz je: " + rate);
            }

        } else {
            System.out.println("Nedostatok financii");
            res = false;
        }
        if (res) {
            if (counter == 1) {
                System.out.println("Váš jednoduchý tiket bol úspešne registrovaný. Veľa štastia!");
            }

            if (counter > 1 && counter != draws) {
                System.out.println("Váš akumulovaný tiket bol úspešne registrovaný. Veľa štastia!");
            }

           /* if (counter > 3 && counter == draws) {
                System.out.println("Váš tiket 'Tutovka' bol úspešne registrovaný. Veľa štastia!");
            }*/

            System.out.println("Potencionálna výhra je " + Math.ceil(suma * rate) + "€");
        }

    }
    private void showTicket(){
        Integer pocet=0;
        double rate=1;
        try {
            for (Ticket t: FindTicket.getInstance().findO(this.id)) {
                pocet++;
                if (t == null) {
                    throw new NullPointerException("Ticket neexistuje");
                }
                Bets b = FindBets.getInstance().findById(t.getBetId());
                if(FindGoals.getInstance().findByBetIdBoolean(b.getId())){
                    System.out.println("Zápas na góly medzi " + FindGoals.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindGoals.getInstance().findByBetId(b.getId()).getName2());
                }
                if(FindWin.getInstance().findByBetIdBoolean(b.getId())){
                    System.out.println("Zápas na výhru medzi " + FindWin.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindWin.getInstance().findByBetId(b.getId()).getName2());
                }

                System.out.println("Id Tiketu:     "+t.getId());
                System.out.println("Id Stávky:     "+b.getId());
                System.out.println("Tip:           "+t.getTip());
                System.out.println("Kurz Tipu:     " + t.getRate());
                System.out.println();
                rate*=t.getRate();

            }
            if (pocet==0) System.out.println("Prázdny tiket");
            if (pocet!=0 && rate==0)  System.out.println("Nepodarilo sa získať kurzy");
        } catch (SQLException ex) {
            System.out.println("Prázdny tiket");
            return;
        }
        if(pocet!=0){
            System.out.println("Celkový kurz tiketu: "+rate);

        }

    }
    private void myTicketsZ(){
        try {
            boolean p = true;
                for (int i = 1; i < FindUser.getInstance().findById(id).getTicketAmount(); i++) {
                    for (Ticket t : FindTicket.getInstance().findByUserIdTicketIdZ(this.id, i)) {
                        p=false;
                        System.out.println( "Vyhodnotený Tiket ID" + t.getTicketId() );
                        System.out.println("Čiastka na tikete: " + t.getAmount());
                        System.out.println("Kurz na tikete:    " + t.getRate());
                        Goals g = FindGoals.getInstance().findByBetId(t.getBetId());
                        Win w = FindWin.getInstance().findByBetId(t.getBetId());
                        if (g != null) {
                            System.out.println(g.getName1() + " vs " + g.getName2());
                            System.out.println("Váš tip " + t.getTip());
                            System.out.println("Výsledok " + g.getWin());
                        }
                        if (w != null) {
                            System.out.println(w.getName1() + " vs " + w.getName2());
                            System.out.println("Váš tip " + t.getTip());
                            System.out.println("Výsledok " + w.getWin());

                        }
                        System.out.println();
                    }
                }

            if(p){
                System.out.println("Ziadny Tiket");
            }
        } catch (SQLException ex) {
            System.out.println(ex.getErrorCode());
        }
    }
    private void myTicketsP(){
        try {
            boolean p = true;
                for (int i = 1; i < FindUser.getInstance().findById(id).getTicketAmount(); i++) {
                    for (Ticket t : FindTicket.getInstance().findByUserIdTicketIdP(this.id, i)) {
                        p=false;
                        System.out.println("Podaný Tiket ID" + t.getTicketId() );
                        System.out.println("Čiastka na tikete: " + t.getAmount());
                        System.out.println("Kurz na tikete:    " + t.getRate());
                        Goals g = FindGoals.getInstance().findByBetId(t.getBetId());
                        Win w = FindWin.getInstance().findByBetId(t.getBetId());
                        if (g != null) {
                            System.out.println(g.getName1() + " vs " + g.getName2());
                            System.out.println("Váš tip " + t.getTip());
                        }
                        if (w != null) {
                            System.out.println(w.getName1() + " vs " + w.getName2());
                            System.out.println("Váš tip " + t.getTip());
                        }
                        System.out.println();
                    }
                }
            if(p){
                System.out.println("Ziadny Tiket");
            }

        } catch (SQLException ex) {
            System.out.println(ex.getErrorCode());
        }
    }
    private void SuccessRate()throws IOException, SQLException, ParseException, TicketException{
        //Pre daný časový interval a daného hráča zistite pomer vyhraných a prehraných tiketov, percentuálnu úspešnosť, celkovú vloženú sumu, celkovú vyhratú sumu a celkový zisk alebo stratu.
        double inputAmount=0;
        double outputAmount=0;
        int pocetW=0;
        int pocetL=0;
        Integer BetId = null;
        List<Ticket> t= FindTicket.getInstance().findAllUser(this.id);
        if(t.size()==0){
            System.out.println("Ziadny uzavrený tiket");
            return;
        }
        for(Ticket a :t){
            inputAmount += a.getAmount();
            pocetL ++;
            if(FindGoals.getInstance().findByBetIdBoolean(a.getBetId())){
                if(FindGoals.getInstance().findByBetId(a.getBetId()).getWin() == a.getTip()){
                    outputAmount += a.getAmount()*a.getRate();
                    pocetL --;
                    pocetW ++;
                }
            }
            if(FindWin.getInstance().findByBetIdBoolean(a.getBetId())){
                if(FindWin.getInstance().findByBetId(a.getBetId()).getWin() == a.getTip()){
                    outputAmount += a.getAmount()*a.getRate();
                    pocetL --;
                    pocetW ++;
                }
            }
        }
            System.out.println("Investované: "+inputAmount);
            System.out.println("Vyhrané: "+outputAmount);
            System.out.println("Balanz: "+ (outputAmount-inputAmount));
            System.out.println("Počet vyhier: "+pocetW);
            System.out.println("Počet prehier: "+pocetL);
    }
}