package Datab.ui;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

import Datab.getset.FindOffice;
/**
 * Tomáš Maťko
 */
public class MenuOffice extends Menu{
    private final Integer id;

    MenuOffice(Integer id) {

        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. Plus/Minus                 *"); //
        System.out.println("* 2. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   stav(); break;
                case "2":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }

        } catch (SQLException ex ) {
            Logger.getLogger(MenuOffice.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    private void stav() throws SQLException {
        Double stav = FindOffice.getInstance().findById(this.id).getKredit();
        if(stav>=100000){
            Double cislo=stav-100000;
            System.out.println("Office je v zisku " + cislo + " €.");
        }
        if(stav<100000){
            Double cislo=100000-stav;
            System.out.println("Office je v strate " + cislo + " €.");
        }
    }
}
