--*/Tom? Ma?ko - Elektronick? St?vkovanie */
drop table if exists uzivatelia cascade;
Create TABLE uzivatelia(
id serial primary key,
meno varchar(20) NOT NULL,
priezvisko varchar(20) NOT NULL,
email varchar(50) UNIQUE,
login varchar(30) NOT NULL,
heslo varchar(30) NOT NULL,
kredit numeric CHECK(kredit>0),
pocetTiketov numeric
);
drop table if exists bookmakeri cascade;
Create TABLE bookmakeri(
id serial primary key,
meno varchar(20) NOT NULL,
priezvisko varchar(20) NOT NULL,
email varchar(50) UNIQUE,
login varchar(30) UNIQUE,
heslo varchar(30) NOT NULL
);
drop table if exists transakcie cascade;
Create TABLE transakcie(
id serial primary key,
suma numeric CHECK(suma>0),
vyber boolean,
datum timestamp,
id_uzivatela integer references uzivatelia(id)
);
drop table if exists stavky cascade;
Create table stavky(
id serial primary key,
datum timestamp,
max numeric CHECK(max>0),
min numeric CHECK(min>=0),
dokedy timestamp,
od_koho integer references bookmakeri(id)
);
drop table if exists tikety cascade;
Create TABLE tikety(
id serial primary key,
id_stavky integer references stavky(id),
id_uzivatela integer references uzivatelia(id),
tip numeric NOT NULL,
idTiketu integer, 
suma numeric CHECK(suma>0),
stav varchar,
vyherny boolean,
datum date
);
drop table if exists kancelaria cascade;
create table kancelaria(
id serial primary key,
kredit numeric,
login varchar,
heslo varchar,
id_stavky integer references stavky(id)
);
drop table if exists goly cascade;
Create Table goly(
id serial primary key,
id_stavky integer references stavky(id),
nazov1 varchar,
nazov2 varchar,
golov_01 numeric CHECK(golov_01>0),
golov_23 numeric CHECK(golov_23>0),
golov_45 numeric CHECK(golov_45>0),
nad5_golov numeric CHECK(nad5_golov>0),
vyhra int
);
drop table if exists vyhra cascade;
Create Table vyhra(
id serial primary key,
id_stavky integer references stavky(id),
nazov1 varchar,
nazov2 varchar,
tim1 numeric CHECK(tim1>0),
tim2 numeric CHECK(tim2>0),
remiza numeric CHECK(remiza>0),
vyherny_tim int
);
