truncate table vyhra,goly,tikety,uzivatelia,bookmakeri,kancelaria,konta,stavky cascade;


---- pomocne tabulky na generovanie dat

drop table if exists first_names cascade;
create table first_names
(
    first_name varchar
);
insert into first_names (first_name)
values	('James'), ('Willie'), ('Chad'), ('Zachary'), ('Mathew'),
	('John'), ('Ralph'), ('Jacob'), ('Corey'), ('Tyrone'),
	('Robert'), ('Larence'), ('Lee'), ('Herman'), ('Darren'),
	('Michael'), ('Nicholas'), ('Melvin'), ('Maurice'), ('Lonnie'),
	('William'), ('Roy'), ('Alfred'), ('Vernon'), ('Lance'),
	('David'), ('Benjamin'), ('Kyle'), ('Roberto'), ('Cody');

drop table if exists last_names cascade;
create table last_names
(
    last_name varchar
);
insert into last_names (last_name)
values	('Smith'), ('Jones'), ('Taylor'), ('Williams'), ('Brown'),
	('Davies'), ('Evans'), ('Wilson'), ('Thomas'), ('Roberts'),
	('Johnson'), ('Lewis'), ('Walker'), ('Robinson'), ('Wood'),
	('Thompson'), ('White'), ('Watson'), ('Jackson'), ('Wright'),
	('Green'), ('Harris'), ('Cooper'), ('King'), ('Lee'),
	('Martin'), ('Clarke'), ('James'), ('Morgan'), ('Hughes'),
	('Edwards'), ('Hill'), ('Moore'), ('Clark'), ('Harrison'),
	('Scott'), ('Young'), ('Morris'), ('Hall'), ('Ward'),
	('Turner'), ('Carter'), ('Phillips'), ('Mitchell'), ('Patel'),
	('Adams'), ('Campbell'), ('Anderson'), ('Allen'), ('Cook');

drop table if exists teams cascade;
create table teams
(
    team varchar
);
insert into teams (team)
values  ('Slovensko'),('Ukrajina'),('USA'),('Maroko'),('Urugay'),('Kamboda'),('Paraguay'),
        ('Venezuela'),('Kanada'),('Belgicko'),('Nemecko'),('Mexiko'),('Kazachstan'),('Madarsko'),('Norsko'),('Polsko'),('Bielorusko'),
        ('Senegal'),('JAR'),('Egypt'),('Izrael'),('Saudsk Arbia'),('na'),('Austrlia'),('panielsko'),
        ('Portugalsko'),('Brazlia'),('Chille'),('Gronsko'),('Irak'),('Thajsko'),('Holandsko'),('vdsko'),
        ('Manchester United'), ('Real Madrid'), ('Manchester City'), ('Chelsea'), ('Liverpool'),
		('Tottenham'), ('Arsenal'), ('Barcelona'), ('Atletico Madrid'), ('Bilbao'),
		('Valencia'), ('Juventus'), ('AC Milano'), ('Inter'), ('Rim'),('Slovan Bratislava'),
        ('Zilina'), ('Trencin'), ('Koice'), ('Spartak Vrable'),
		('Tm Junej Moravy'),('Budapest'),('Martin'),('Poprad'),('Nov Zmky'),('Nitra'),
        ('Bansk Bystrica'),('Raksko'),('Taliansko'),('Rusko'),('Anglicko'),('esko');

---------------------------------------------------------------------------------------------------------
---- kancelaria
insert into kancelaria (kredit,login,heslo)
values('100000','kancelaria','kancelaria');

---- uzivatelia
with data as ( 
	select	tmp1.i, tmp2.i,
			first_name,
			last_name,
			first_name || '.' || seq.i || last_name || '@gmail.com' as email,
			floor(random() * (1000 - 50) + 50) as kredit,
            'a' || seq.i as login,
            'a' || seq.i  as heslo
	from generate_series(1, 10000) as seq(i)
	cross join lateral (select seq.i, * from first_names order by random() limit 1) as tmp1
	cross join lateral (select seq.i, * from last_names order by random() limit 1) as tmp2
)
insert into uzivatelia (meno, priezvisko, email,kredit,pocetTiketov,login,heslo)
select first_name, last_name, email, kredit,2,login,heslo from data;

insert into uzivatelia(meno,priezvisko,login,heslo,kredit,email,pocetTiketov)
values('Tomas','Matko','tomas','matko','1000','tkolo789@gmail.com',1);



---Bookmakeri
with data as (
	select	tmp1.i, tmp2.i,
			first_name,
			last_name,
			first_name || '.' || seq.i || last_name || '@gmail.com' as email,
            'a' || seq.i as login,
            'a' || seq.i  as heslo
	from generate_series(1, 1000) as seq(i)
	cross join lateral (select seq.i, * from first_names order by random() limit 1) as tmp1
	cross join lateral (select seq.i, * from last_names order by random() limit 1) as tmp2
)
insert into bookmakeri (meno, priezvisko, email,login,heslo)
select first_name, last_name, email,login,heslo from data;


insert into bookmakeri (meno, priezvisko, email,login,heslo)
values  ('bookmaker','bookmaker','bookmaker@gmail.com','bookmaker','bookmaker');


----stavky
with data as ( 
	select  
			timestamp '2019-05-04 12:00:00' + random() * (timestamp '2020-05-04 12:00:00' - timestamp '2019-05-04 12:00:00') as datum,
			floor(random() * (5)) as min,
			floor(random() * (5000)+ 500) as max
	from generate_series(1, 10000) as seq(i)  
)

insert into stavky (datum,max,min)
select datum,max,min from data;
update stavky set dokedy = (datum - INTERVAL '1' HOUR);
update stavky set od_koho = floor(random()* (6) + 1 );

------transakcie

with data as ( 
	select
			timestamp '2016-02-04 12:00:00' + random() * (timestamp '2019-02-04 12:00:00' - timestamp '2016-02-04 12:00:00') as datum,
			floor(random() * (10) + 1)*5 as suma,
			cast(cast(random() as integer)as boolean) as vyber,
			floor(random() * (10001)+ 1) as uziv
	from generate_series(1, 2500) as seq(i)
)
insert into transakcie (suma,vyber,datum,id_uzivatela)
select suma,vyber,datum,uziv from data;

------goly
with data as ( 
	select	team1.i, team2.i,
			team1.team as first,
			team2.team as second,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz1,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz2,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz3,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz4,
			floor(random() * (4) + 1)  as win,
            team1.i as stavka_id
            
	from generate_series(1, 2000) as seq(i)
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team1
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team2
)
insert into goly (golov_01,golov_23,golov_45,nad5_golov,vyhra,nazov1,nazov2,id_stavky)
select kurz1,kurz2,kurz3,kurz4,win,first,second,stavka_id from data;

with data as ( 
	select	team1.i, team2.i,
			team1.team as first,
			team2.team as second,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz1,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz2,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz3,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz4,
            4000+team1.i as stavka_id
	from generate_series(1, 2000) as seq(i)
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team1
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team2
)
insert into goly (golov_01,golov_23,golov_45,nad5_golov,nazov1,nazov2,id_stavky)
select kurz1,kurz2,kurz3,kurz4,first,second,stavka_id from data;

------vyhra

with data as ( 
	select	team1.i, team2.i,
			team1.team as first,
			team2.team as second,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz1,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz2,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz3,
			floor(random() * (3) + 1)  as vyhra,
            2000+team1.i as stavka_id
	from generate_series(1, 2000) as seq(i)
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team1
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team2
)
insert into vyhra (tim1,tim2,remiza,vyherny_tim,nazov1,nazov2,id_stavky)
select kurz1,kurz2,kurz3,vyhra,first,second,stavka_id from data;

with data as ( 
	select	team1.i, team2.i,
			team1.team as first,
			team2.team as second,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz1,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz2,
			cast((random() * (5) + 1) as decimal(8,2)) as kurz3,
            6000+team1.i as stavka_id
	from generate_series(1, 4000) as seq(i)
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team1
	cross join lateral (select seq.i, * from teams order by random() limit 1) as team2
)
insert into vyhra (tim1,tim2,remiza,nazov1,nazov2,id_stavky)
select kurz1,kurz2,kurz3,first,second,stavka_id from data;


drop table if exists teams cascade;
drop table if exists first_names cascade;
drop table if exists last_names cascade;

-------Tikety

with data as ( 
	select  
            seq.i as stavka,
            seq.i as uziv,
            'p' as st,
            floor(random() * (100)+1) as suma,
            floor(random()* 2 + 1) as tip
	from generate_series(1, 8000) as seq(i)  
)

insert into tikety (id_stavky,id_uzivatela,tip,idTiketu,suma,stav)
select stavka,uziv,tip,1,suma,st from data;

with data as ( 
	select  
            seq.i as stavka,
            seq.i as uziv,
            'z' as st,
            floor(random() * (100)+1) as suma,
            floor(random()* 2 + 1) as tip
	from generate_series(8001, 10000) as seq(i)  
)
insert into tikety (id_stavky,id_uzivatela,tip,idTiketu,suma,stav)
select stavka,uziv,tip,1,suma,st from data;
