package Datab.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import Datab.DbContext;
import Datab.getset.*;
/**
 * Tomáš Maťko
 */
public class Putinout {
    private static final Putinout INSTANCE = new Putinout();

    public static Putinout getInstance() {
        return INSTANCE;
    }

    public boolean putIn(Integer id, Integer suma) throws SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {

            Users user=FindUser.getInstance().findById(id);
            user.setMoney(FindUser.getInstance().findById(id).getMoney()+suma);
            user.update();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String datum=sdf.format(timestamp);
            Date date = sdf.parse(datum);
            Timestamp vysl = new Timestamp(date.getTime());

            Account instance = new Account();
            instance.setUser_id(id);
            instance.setSuma(suma);
            instance.setDatum(vysl);
            instance.setVyber(false);
            instance.insert();



            DbContext.getConnection().commit();
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
            DbContext.getConnection().setAutoCommit(true);
        }
    }


    public boolean takeOut(Integer id, Integer suma) throws SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Users user=FindUser.getInstance().findById(id);
            user.setMoney(FindUser.getInstance().findById(id).getMoney()-suma);
            user.update();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String datum=sdf.format(timestamp);
            Date date = sdf.parse(datum);
            java.sql.Timestamp vysl = new java.sql.Timestamp(date.getTime());

            Account instance = new Account();
            instance.setUser_id(id);
            instance.setSuma(suma);
            instance.setDatum(vysl);
            instance.setVyber(true);
            instance.insert();

            DbContext.getConnection().commit();
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
            DbContext.getConnection().setAutoCommit(true);
        }
    }
}
