package Datab.actions;

import Datab.DbContext;
import Datab.getset.Bets;
import Datab.getset.Ticket;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;

public class TicketAccept {
    private static final TicketAccept INSTANCE = new TicketAccept();

    public TicketAccept() {
    }

    public static TicketAccept getInstance() {
        return INSTANCE;
    }

    public boolean potvrd(Integer id, Double suma, Integer cislo, Integer id_udalost) throws TicketException, SQLException, ParseException {
        if (suma == null) {
            throw new IllegalArgumentException("suma nesmie byt null");
        } else {
            DbContext.getConnection().setTransactionIsolation(8);
            DbContext.getConnection().setAutoCommit(false);

            boolean boolhelp;
            try {
                Ticket tiket = new Ticket();
                tiket.setId(id);
                tiket.setAmount(suma);
                tiket.setProgress("p");
                tiket.setTicketId(cislo);
                tiket.setDate(new java.sql.Date(Calendar.getInstance().getTime().getTime()));
                tiket.setWin(false);
                tiket.update();
                DbContext.getConnection().commit();
                boolhelp = true;
            } catch (SQLException e) {
                DbContext.getConnection().rollback();
                throw e;
            } finally {
                DbContext.getConnection().setAutoCommit(true);
            }

            return boolhelp;
        }
    }
}
