package Datab.getset;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
/**
 * Tomáš Maťko
 */
public class Account extends BaseGateway {

    private Integer id;
    private Integer user_id;
    private Timestamp datum;
    private boolean vyber;
    private float suma;

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }

    public int getUser_id() { return user_id; }
    public void setUser_id(Integer user_id) { this.user_id = user_id; }

    public Timestamp getDatum() { return datum; }
    public void setDatum(Timestamp datum) { this.datum = datum; }

    public boolean getVyber() { return vyber; }
    public void setVyber(boolean vyber) { this.vyber = vyber; }

    public float getSuma() { return suma; }
    public void setSuma(float suma) { this.suma = suma; }





    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO transakcie (suma, vyber, datum,id_uzivatela) VALUES (?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setFloat(1, suma);
        s.setBoolean(2, vyber);
        s.setTimestamp(3, datum);
        s.setInt(4, user_id);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        update("UPDATE transakcie SET suma = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setFloat(1, suma);
        s.setInt(2, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM transakcie WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
}
