
package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
/**
 * Tomáš Maťko
 */
public class FindAccount extends BaseFinder<Account> {

    private static final FindAccount INSTANCE = new FindAccount();

    public static FindAccount getInstance() { return INSTANCE; }

    private FindAccount() { }

    public Account findById(int id) throws SQLException {
        return findByInt("SELECT * FROM transakcie WHERE id = ?", id);
    }

    public Account findByUserId(int id) throws SQLException {
        return findByInt("SELECT * FROM transakcie WHERE id_uzivatela = ?", id);
    }


    public List<Account> findAll() throws SQLException {
        return findAll("SELECT * FROM transakcie");
    }

    public List<Account> findAllByUserId(int id) throws SQLException {
        try {
           return findAllByInt("SELECT * FROM transakcie WHERE id_uzivatela = ?",id);
        } catch (SQLException ex) {
            System.out.println(ex);
        }
        return null;

    }

    @Override
    protected Account load(ResultSet r) throws SQLException {
        Account c = new Account();

        c.setId(r.getInt("id"));
        c.setSuma(r.getFloat("suma"));
        c.setDatum(r.getTimestamp("datum"));
        c.setVyber(r.getBoolean("vyber"));
        c.setUser_id(r.getInt("id_uzivatela"));

        return c;
    }
}