
package Datab.getset;

import Datab.DbContext;
import org.postgresql.core.Query;
import org.postgresql.core.SqlCommand;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Tomáš Maťko
 */
public class FindBets extends BaseFinder<Bets>{
    private static final FindBets INSTANCE = new FindBets();
    
    public static FindBets getInstance() { return INSTANCE; }
    
    private FindBets() { }
		
    public Bets findById(int id) throws SQLException {
        return findByInt("SELECT * FROM stavky WHERE id = ?", id);
    }
    public Bets findByIdAkt(int id) throws SQLException {
        return findByInt("SELECT * FROM stavky WHERE id = ? AND dokedy>=NOW()", id);
    }
    
    /*public Bets findByIdUdalosti(int id) throws SQLException {
        return findByInt("SELECT * FROM udalost WHERE id_udalost = ?", id);
    }*/
    
    /*public List<Bets> findNaj() {
        try {
            return findAll("SELECT * FROM stavky WHERE dokedy>=NOW() ORDER BY pocetpodani DESC LIMIT 3");
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
        return null;
    }*/
    
    public List<Bets> findNow() {
        try {
            return findAll("SELECT * FROM stavky WHERE dokedy>=NOW()");
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
        return null;
    }
    public List<Bets> findNowLimit(int begin,int end) throws SQLException {
        try {
            String query = "SELECT * FROM stavky WHERE dokedy>=NOW() offset ? limit ?";

            PreparedStatement ps = DbContext.getConnection().prepareStatement(query);
            ps.setInt(1, begin);
            ps.setInt(2, end);
            if (ps == null) {
                throw new NullPointerException("query cannot be null");
            }
            ResultSet r = ps.executeQuery();

            List<Bets> e = new ArrayList<Bets>();

            while (r.next()) {
                e.add(load(r));
            }
            return e;
        }
        catch (SQLException ex){
            System.out.println(ex.getErrorCode());
        }
        return null;
    }
   
 

    public List<Bets> findAll() throws SQLException {
        return findAll("SELECT * FROM stavky ");
    }
   
    @Override
    protected Bets load(ResultSet r) throws SQLException {
        Bets c = new Bets();
        
        c.setId(r.getInt("id"));
        c.setId_bookmaker(r.getInt("od_koho"));
        c.setDate(r.getTimestamp("datum"));
        c.setUntil(r.getTimestamp("dokedy"));
        c.setMax(r.getInt("max"));
        c.setMin(r.getInt("min"));
        
        return c;
    }


}
