
package Datab.getset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
/**
 * Tomáš Maťko
 */
public class FindUser extends BaseFinder<Users> {
    
    private static final FindUser INSTANCE = new FindUser();
    
    public static FindUser getInstance() { return INSTANCE; }
    
    private FindUser() { }
		
    public Users findById(int id) throws SQLException {
        return findByInt("SELECT * FROM uzivatelia WHERE id = ?", id);
    }
    
    public Users findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM uzivatelia WHERE login = ?", login);
    }
    
     public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM uzivatelia WHERE login = ?", login).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }

    public List<Users> findAll() throws SQLException {
        return findAll("SELECT * FROM uzivatelia");
    }


    @Override
    protected Users load(ResultSet r) throws SQLException {
        Users c = new Users();

        c.setId(r.getInt("id"));
        c.setName(r.getString("meno"));
        c.setLogin(r.getString("login"));
        c.setPasswd(r.getString("heslo"));
        c.setSurname(r.getString("priezvisko"));
        c.setEmail(r.getString("email"));
        c.setMoney(r.getFloat("kredit"));
        c.setTicketAmount(r.getInt("pocetTiketov"));
        return c;
    }

}
