
package Datab.getset;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
/**
 * Tomáš Maťko
 */
public class Ticket extends BaseGateway {

    private Integer id;
    private Integer BetId;
    private Integer user;
    private Integer tip;
    private Integer idTiketu;
    private Double suma;
    private String progress;
    private Boolean win;
    private Date datum;
    private Double rate;
    
    
    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }
    
    public Integer getBetId() { return BetId;	}
    public void setBetId(Integer BetId) { this.BetId = BetId; }

    public Integer getUser() { return user; }
    public void setUser(Integer user) { this.user = user; }
    
    public Integer getTip() { return tip; }
    public void setTip(Integer tip) { this.tip = tip; }
    
    public Integer getTicketId() { return idTiketu; }
    public void setTicketId(Integer idTiketu) { this.idTiketu = idTiketu; }
    
    public Date getDate() { return datum; }
    public void setDate(Date datum) { this.datum = datum; }

    public Double getAmount() {return suma;}
    public void setAmount(Double suma){this.suma=suma; }

    public String getProgress() { return progress; }//otvorena = otvoreny,p=podany,z = zatvoreny
    public void setProgress(String progress) { this.progress = progress; }

    public Boolean getWin(){return win; }
    public void setWin(Boolean win) { this.win = win;}

    public double getRate() throws SQLException {
        if (FindWin.getInstance().findByBetIdBoolean(BetId)) {
            if (tip == 1) {
                return FindWin.getInstance().findByBetId(BetId).getTeam1();
            } else if (tip == 0) {
                return FindWin.getInstance().findByBetId(BetId).getDraw();
            } else if (tip == 2) {
                return FindWin.getInstance().findByBetId(BetId).getTeam2();
            }
        }
        if (FindGoals.getInstance().findByBetIdBoolean(BetId)) {
            if (tip == 1) {
                return FindGoals.getInstance().findByBetId(BetId).get01();
            } else if (tip == 2) {
                return FindGoals.getInstance().findByBetId(BetId).get23();
            } else if (tip == 3) {
                return FindGoals.getInstance().findByBetId(BetId).get45();
            } else if (tip == 4) {
                return FindGoals.getInstance().findByBetId(BetId).get6();
            }
        }
        System.out.println("Nepodarilo sa ziskat kurz udalosti");
        return 0;
    }

    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO tikety (id_uzivatela, id_stavky, tip, idTiketu, suma,stav,datum) VALUES (?,?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setInt(1, user);
        s.setInt(2, BetId);
        s.setInt(3, tip);
        s.setInt(4, idTiketu);
        s.setDouble(5,suma);
        s.setString(6,"o");
        s.setDate(7,datum);


        ;
        
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE tikety SET  suma = ?, stav = ?, idTiketu=?,vyherny = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException  {
        s.setDouble(1, suma);
        s.setString(2, progress);
        s.setDouble(3, idTiketu);
        s.setBoolean(4,win);
        s.setInt(5,id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }
        delete("DELETE FROM tikety WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
	
}