package Datab.getset;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Tomáš Maťko
 */
public class Win extends BaseGateway {

    private Integer id;
    private Integer stavka;
    private double team1;
    private double team2;
    private double draw;
    private Integer win;
    private String name1;
    private String name2;
 
    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }	
    
    public Integer getBetId() { return stavka; }
    public void setBetId(Integer stavka) { this.stavka = stavka; }

    public String getName1() { return name1; }
    public void setName1(String name1) { this.name1 = name1; }

    public String getName2() { return name2; }
    public void setName2(String name2) { this.name2 = name2; }
    
    public double getTeam1() { return team1; }
    public void setTeam1(double team1) { this.team1 = team1; }

    public double getTeam2() { return team2; }
    public void setTeam2(double team2) { this.team2 = team2; }
    
    public double getDraw() { return draw; }
    public void setDraw(double draw) { this.draw = draw; }

    public Integer getWin() { return win; }
    public void setWin(Integer win) { this.stavka = win; }

    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO vyhra (id_stavky, tim1, tim2, remiza, nazov1, nazov2) VALUES (?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setInt(1, stavka);
        s.setDouble(2, team1);
        s.setDouble(3, team2);
        s.setDouble(4, draw);
        s.setString(5,name1);
        s.setString(6,name2);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE vyhra SET vyherny_tim=? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setInt(1, win);
        s.setInt(2, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM vyhra WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
	
}