package Datab.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import Datab.getset.*;
import Datab.actions.*;
import Datab.getset.*;

/**
 * Tomáš Maťko
 */
public class BookmakerMenu extends Menu{
    private final Integer id;

    BookmakerMenu(Integer id) {

        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. Vylistovat StavkyVyhry     *");
        System.out.println("* 2. Vylistovat Goly            *");
        System.out.println("* 3. Pridat Stavku              *");
        System.out.println("* 4. Odstranit stavku           *");
        System.out.println("* 5. Pridat údaj o výhre        *");
        System.out.println("* 6. Listni Tikety podla Stavky *");
        System.out.println("* 7. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   PossibleBetsW(); break;
                case "2":   PossibleBetsG(); break;
                case "3":   AddBet();break;
                case "4":   DeleteBet();break;
                case "5":   AddWin();break;
                case "6":   showTicket();
                case "7":   exit();
                default:    System.out.println("Unknown option"); break;
            }

        } catch(IOException e ) {
            throw new RuntimeException(e);
        } catch (ParseException | SQLException ex) {
           System.out.println(ex.getMessage());
        }

    }

    private void PossibleBetsW() {
        try {
            Iterator pom = FindBets.getInstance().findNow().iterator();
            Integer counter=0;
            System.out.println("Stávky na výhry: -------------------------------------------------------------------");

            while(pom.hasNext()) {

                Bets stavky = (Bets)pom.next();
                if (stavky == null) {
                    throw new NullPointerException("Stala sa chyba");
                }
                Integer BetId = stavky.getId();
                if (FindWin.getInstance().findByBetIdBoolean(BetId)){
                    counter++;
                    System.out.println(counter+".");
                    System.out.println("Identifikátor stávky:        " + BetId);
                    System.out.println("Stávka otvorená do:          "+stavky.getUntil());
                }

                if (FindWin.getInstance().findByBetIdBoolean(BetId)) {
                    if (BetId < 1) {
                        throw new NullPointerException("Id stávky nesmie byt null");
                    }
                    Win v = FindWin.getInstance().findByBetId(BetId);
                    System.out.println("Tip stávky: Výhra");
                    System.out.println("Tip 1 -> "+ v.getName1()+"    kurz: " + v.getTeam1());
                    System.out.println("Tip 2 -> "+ v.getName2()+"    kurz: " + v.getTeam2());
                    System.out.println("Tip 0: Remíza     kurz: " + v.getDraw());
                    System.out.println();
                }
            }
        } catch (SQLException var3) {
            System.out.println("Nenasla sa ziadna udalost");
        }

    }
    private void PossibleBetsG() {
        try {

            Iterator pom = FindBets.getInstance().findNow().iterator();
            Integer counter=0;
            System.out.println("Stávky na góly: -------------------------------------------------------------------");
            while(pom.hasNext()) {

                Bets stavky = (Bets)pom.next();
                if (stavky == null) {
                    throw new NullPointerException("Stala sa chyba");
                }
                Integer BetId = stavky.getId();
                if (FindGoals.getInstance().findByBetIdBoolean(BetId)){
                    counter++;
                    System.out.println(counter+".");
                    System.out.println("Identifikátor stávky:        " + BetId);
                    System.out.println("Stávka otvorená do:          "+stavky.getUntil());
                }

                if (FindGoals.getInstance().findByBetIdBoolean(BetId)) {
                    if (BetId <1) {
                        throw new NullPointerException("Id stávky nesmie byt null");
                    }
                    Goals g = FindGoals.getInstance().findByBetId(BetId);

                    System.out.println("Tip stávky: Počet gólov v zápase " + g.getName1() + " proti " + g.getName2() );
                    System.out.print("Tip 1 -> 0-1 Gól :     ");
                    System.out.println(g.get01());
                    System.out.print("Tip 2 -> 2-3 Góly :    ");
                    System.out.println(g.get23());
                    System.out.print("Tip 3 -> 4-5 Góly :    ");
                    System.out.println(g.get45());
                    System.out.print("Tip 4 -> Nad 5 Gólov :    ");
                    System.out.println(g.get6());
                    System.out.println();
                }
            }
        } catch (SQLException var3) {
            System.out.println("Nenasla sa ziadna udalost");
        }

    }
    private void AddBet()throws IOException, ParseException, SQLException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Typ Udalosti");
        System.out.println("1 = Výhra");
        System.out.println("2 = Počet Gólov");
        int volba = Integer.parseInt(br.readLine());
        Bets bet=new Bets();

        System.out.print("Zadaj datum konania(yyyy-mm-dd hh:mm:ss): ");
        String pattern = "yyyy-mm-dd hh:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = simpleDateFormat.parse(br.readLine());
        java.sql.Timestamp dateTS = new java.sql.Timestamp(date.getTime());

        System.out.print("Zadaj datum konca stavkovania(yyyy-MM-dd HH:mm:ss): ");
        String s= br.readLine();
        Date den = simpleDateFormat.parse(s);
        java.sql.Timestamp end = new java.sql.Timestamp(den.getTime());

        System.out.print("Zadajte minmalnu sumu stavky: ");
        Integer min= Integer.parseInt(br.readLine());
        System.out.print("Zadajte maximalnu sumu stavky: ");
        Integer max= Integer.parseInt(br.readLine());

        bet.setMax(max);
        bet.setMin(min);
        bet.setUntil(end);
        bet.setId_bookmaker(this.id);
        bet.setDate(dateTS);
        bet.insert();

        if(volba==1){
            Win w=new Win();
            w.setBetId(bet.getId());
            System.out.print("Meno prvého teamu: ");
            w.setName1(br.readLine());
            System.out.print("Meno druhého teamu: ");
            w.setName2(br.readLine());
            System.out.print("Kurz 1: ");
            w.setTeam1(Double.parseDouble(br.readLine()));
            System.out.print("Kurz 2: ");
            w.setTeam2(Double.parseDouble(br.readLine()));
            System.out.print("Kurz 0: ");
            w.setDraw(Double.parseDouble(br.readLine()));
            w.insert();

        }
        else if(volba==2){
            Goals w=new Goals();
            w.setBetId(bet.getId());
            System.out.print("Meno prvého teamu: ");
            w.setName1(br.readLine());
            System.out.print("Meno druhého teamu: ");
            w.setName2(br.readLine());
            System.out.print("kurz 0-1: ");
            w.set01(Double.parseDouble(br.readLine()));
            System.out.print("kurz 2-3: ");
            w.set23(Double.parseDouble(br.readLine()));
            System.out.print("kurz 4-5: ");
            w.set45(Double.parseDouble(br.readLine()));
            System.out.print("kurz >5: ");
            w.set6(Double.parseDouble(br.readLine()));
            w.insert();
        }
        System.out.println();
        System.out.print("Udalost bola uspesne vytvorena");
    }
    private void DeleteBet()throws IOException, ParseException, SQLException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Zadajte id stávky:");
        Integer BetId=Integer.parseInt(br.readLine());
        Bets bet =FindBets.getInstance().findById(BetId);

        if (bet ==null){
            System.out.println("Neexistujúca stávka");
        }
        else{
            BetDel.getInstance().delete(id,BetId,bet);
        }


    }
    private void AddWin()throws IOException, ParseException, SQLException{
        List<Goals> g = FindGoals.getInstance().findAllNull();
        List<Win> w = FindWin.getInstance().findAllNull();
        if(g==null && w==null){
            System.out.println("Ziadne nerozhodnuté stávky");
        }
        System.out.println("Chcete doplnit/zmenit udaj o vyhre do Vyhier(0) alebo Golov(1)?");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        if(Integer.parseInt(br.readLine())==0){
            System.out.println("Id Stavky?");
            Goals t = FindGoals.getInstance().findByBetId(Integer.parseInt(br.readLine()));
            System.out.println("Ktora z moznosti 1-4 je spravna?");
            int id = Integer.parseInt(br.readLine());
            if(id<5 && id>0){
                t.setWin(id);
                t.update();
                System.out.println("Stavka nastavena");
            }
            else{
                System.out.println("Zly input");
            }

        }
        if(Integer.parseInt(br.readLine())==1){
            System.out.println("Id Stavky?");
            Goals t = FindGoals.getInstance().findByBetId(Integer.parseInt(br.readLine()));
            System.out.println("Ktora z moznosti 0-2 je spravna?");
            int id = Integer.parseInt(br.readLine());
            if(id<3 && id>-1){
                t.setWin(id);
                t.update();
                System.out.println("Stavka nastavena");
            }
            else{
                System.out.println("Zly input");
            }
        }

    }
    private void showTicket(){
        try {
            System.out.println("Zadajte id stavky");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            Integer betId = Integer.parseInt(br.readLine());
            boolean f=true;
            if(FindTicket.getInstance().findByBetId(betId)==null){
                System.out.println("Stavka neexistuje");
                return;
            }
            else{
                for (Ticket t: FindTicket.getInstance().findByBetId(betId)) {
                    if (t == null) {
                        throw new NullPointerException("Ziadne uzatvorene tickety");
                    }
                    Bets b = FindBets.getInstance().findById(t.getBetId());
                    if(FindGoals.getInstance().findByBetIdBoolean(b.getId())&& f ){
                        System.out.println("Zápas na góly medzi " + FindGoals.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindGoals.getInstance().findByBetId(b.getId()).getName2());
                        f=false;
                    }
                    if(FindWin.getInstance().findByBetIdBoolean(b.getId())&& f){
                        System.out.println("Zápas na výhru medzi " + FindWin.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindWin.getInstance().findByBetId(b.getId()).getName2());
                        f=false;
                    }
                    System.out.println("Id Tiketu:     "+t.getId());
                    System.out.println("Id Stávky:     "+b.getId());
                    System.out.println("Tip:       "+t.getTip());
                    System.out.println("Kurz Tipu:     " + t.getRate());
                    System.out.println("Suma :     " + t.getAmount());
                    System.out.println();
                }
            }
        } catch (SQLException ex) {
            System.out.println(ex.getErrorCode());
        } catch (IOException e) {
            System.out.println(e.getCause());
        }
    }
}

