package Datab.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Iterator;

import Datab.getset.*;
import Datab.actions.*;
/**
 * Tomáš Maťko
 */

public class MoneyMenu extends Menu {



        private final Integer id;

        MoneyMenu(Integer id) {
            this.id = id;
        }


        @Override
        public void print() {
            System.out.println("**********Správa Financii*********");
            System.out.println("* 1. Vlozenie penazi             *");
            System.out.println("* 2. Vybranie penazi             *");
            System.out.println("* 3. Stav penazneho zostatku     *");
            System.out.println("* 4. Vypis transakcii na ucte    *");
            System.out.println("* 5. Vrátiť sa do Main Menu      *");
            System.out.println("**********************************");
        }

        @Override
        public void handle(String option) {
            try {
                switch (option) {
                    case "1":   putIn(); break;
                    case "2":   takeOut(); break;
                    case "3":   stavKonta(); break;
                    case "4":   WriteTransaction(); break;
                    case "5":   exit(); break;
                    default:    System.out.println("Unknown option"); break;
                }
            } catch(IOException | SQLException | ParseException e) {
                throw new RuntimeException(e);

            }
        }

        private void stavKonta(){
            try {
                System.out.println("Zostavajuci kredit je: " + FindUser.getInstance().findById(id).getMoney() + "€");
            } catch (SQLException e){

            }
        }

        private void Info() throws SQLException {
            System.out.println("Id:         " + FindUser.getInstance().findById(id).getId());
            System.out.println("Meno:       " + FindUser.getInstance().findById(id).getName());
            System.out.println("Priezvisko: " + FindUser.getInstance().findById(id).getSurname());
            System.out.println("Email:      " + FindUser.getInstance().findById(id).getEmail());
        }


        private void putIn() throws SQLException, ParseException{
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Zadajte kolko chcete vlozit na konto: ");

            int suma = 0;
            try {
                suma = Integer.parseInt(br.readLine());
            } catch (IOException e) {
                e.printStackTrace();
            }
            Putinout.getInstance().putIn(this.id, suma);

            System.out.print("Vas kredit bol navyseny o " + suma + "€.");

        }

        private void takeOut() throws SQLException, IOException, ParseException{
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Zadajte sumu: ");
            int suma = Integer.parseInt(br.readLine());
            if (FindUser.getInstance().findById(this.id).getMoney()-suma<0){
                System.out.println("Nedostatok financii");
            }
            else{
                Putinout.getInstance().takeOut(this.id, suma);
                System.out.print("Z Vášho kreditu bolo strhnutých " + suma + "€.");
            }
        }

        private void WriteTransaction() throws SQLException,IOException,ParseException{
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Výpis minulých transakcii: ");
            try{
                int counter =0;
                for (Account vec : FindAccount.getInstance().findAllByUserId(this.id)){
                    counter ++;
                    if(vec.getVyber()){
                        System.out.println(counter + ". Výber z účtu");
                    }
                    else{
                        System.out.println(counter + ". Vklad na účet");
                    }
                    System.out.print("Dátum:   ");
                    System.out.println(vec.getDatum());
                    System.out.print("Suma:    ");
                    System.out.println(vec.getSuma() +"€");
                    System.out.println();
                }
            } catch (NullPointerException ex)   {
                System.out.println();
            }

        }
    }