package Datab.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.BufferPoolMXBean;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import Datab.getset.*;

/**
 * Tomáš Maťko
 */
public class OfficeMenu extends Menu{
    private final Integer id;

    OfficeMenu(Integer id) {

        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. Plus/Minus                 *");
        System.out.println("* 2. Plus/Minus Stavka          *");
        System.out.println("* 3. Listuj Tikety              *");
        System.out.println("* 4. Listni Tikety podla Stavky *");
        System.out.println("* 5. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   stav(); break;
                case "2":   BetBalance();break;
                case "3":   showTickets();
                case "4":   showTicket();
                case "5":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }

        } catch (SQLException ex ) {
            Logger.getLogger(OfficeMenu.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    private void stav() throws SQLException {
        Double stav = FindOffice.getInstance().findById(this.id).getKredit();
        System.out.println("Kredit Office-u je  " + stav + " €.");
        if(stav>=100000){
            Double cislo=stav-100000;
            System.out.println("Office je v zisku " + cislo + " €.");
        }
        if(stav<100000){
            Double cislo=100000-stav;
            System.out.println("Office je v strate " + cislo + " €.");
        }
    }
    private void BetBalance() throws SQLException {
        double suma=0;
        System.out.println("Zadajte id stavky");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Integer BetId = null;
        try {
            BetId = Integer.parseInt(br.readLine());
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<Ticket> t= FindTicket.getInstance().findByBetId(BetId);
        for(Ticket a :t){
            suma += a.getAmount();
            if(FindGoals.getInstance().findByBetIdBoolean(a.getBetId())){
                if(FindGoals.getInstance().findByBetId(a.getBetId()).getWin() == a.getTip()){
                    suma = suma - a.getAmount()*a.getRate();
                }
            }
            if(FindWin.getInstance().findByBetIdBoolean(a.getBetId())){
                if(FindWin.getInstance().findByBetId(a.getBetId()).getWin() == a.getTip()){
                    suma = suma - a.getAmount()*a.getRate();
                }
            }
        }
        if(suma>=0){
            System.out.println("Zisk  na stávke "+BetId+" = "+suma);
        }
        else{
            System.out.println("Strata na stávke "+BetId+" = "+suma);
        }

    }
    private void showTickets()throws SQLException {
            for (Ticket t: FindTicket.getInstance().FindAllZ()) {
                if (t == null) {
                    throw new NullPointerException("Ziadne uzatvorene tickety");
                }
                Bets b = FindBets.getInstance().findById(t.getBetId());
                if(FindGoals.getInstance().findByBetIdBoolean(b.getId()) ){
                    System.out.println("Zápas na góly medzi " + FindGoals.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindGoals.getInstance().findByBetId(b.getId()).getName2());

                }
                if(FindWin.getInstance().findByBetIdBoolean(b.getId())){
                    System.out.println("Zápas na výhru medzi " + FindWin.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindWin.getInstance().findByBetId(b.getId()).getName2());

                }
                System.out.println("Id Tiketu:     "+t.getId());
                System.out.println("Id Uzivatela:     "+t.getUser());
                System.out.println("Tip:       "+t.getTip());
                System.out.println("Kurz Tipu:     " + t.getRate());
                System.out.println("Suma :     " + t.getAmount());
                System.out.println();
             }
    }
    private void showTicket()throws SQLException{
            System.out.println("Zadajte id stavky");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Integer betId = null;
        try {
            betId = Integer.parseInt(br.readLine());
        } catch (IOException e) {
            e.printStackTrace();
        }
        boolean f=true;
            if(FindTicket.getInstance().findByBetId(betId)==null){
                System.out.println("Stavka neexistuje");
                return;
            }
            else{
                for (Ticket t: FindTicket.getInstance().findByBetId(betId)) {
                    if (t == null) {
                        throw new NullPointerException("Ziadne uzatvorene tickety");
                    }
                    Bets b = FindBets.getInstance().findById(t.getBetId());
                    if(FindGoals.getInstance().findByBetIdBoolean(b.getId())&& f ){
                        System.out.println("Zápas na góly medzi " + FindGoals.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindGoals.getInstance().findByBetId(b.getId()).getName2());
                        f=false;
                    }
                    if(FindWin.getInstance().findByBetIdBoolean(b.getId())&& f){
                        System.out.println("Zápas na výhru medzi " + FindWin.getInstance().findByBetId(b.getId()).getName1() + " vs " + FindWin.getInstance().findByBetId(b.getId()).getName2());
                        f=false;
                    }
                    System.out.println("Id Tiketu:     "+t.getId());
                    System.out.println("Id Stávky:     "+b.getId());
                    System.out.println("Tip:       "+t.getTip());
                    System.out.println("Kurz Tipu:     " + t.getRate());
                    System.out.println("Suma :     " + t.getAmount());
                    System.out.println();
                }
            }
        }
    }

