package Worms;

class Bullet {
	private double x = 0;
	private double y = 0;
	private double dx = 10;
	private double dy = 10;
	double time=0;
	double delay;

	/**
	 * Konstruktor
	 * @param posX x-ova pozicia naboja
	 * @param posY y-ova pozicia naboja
	 * @param dx x-ova rychlost
	 * @param dy y-ova rychlost
	 */
	public Bullet(double posX,double posY,double dx, double dy) {
		super();
		this.x = posX;
		this.y = posY;
		this.dx = dx;
		this.dy=dy;
		this.delay=0;
	}

	/**
	 * Posuva naboj
	 * @param h vyska sceny
	 * @param w sirka sceny
	 * @return false= naboj mimo sceny, true= naboj je vnutri sceny
	 */
	public boolean update(int h,int w) {
		if (x < 0 || y < 0 || x > w || y > h) {
			return false;
		}
		dy = dy+time;
		time = time +  0.01;
		x += dx;
		y += dy;
		if(dy<3){
			delay +=0.05;
		}
		else{
			delay +=0.2;
		}
		return true;
	}

	/**
	 * vrati X
	 * @return x
	 */
	public double getX() {
		return x;
	}
	/**
	 * vrati Y
	 * @return y
	 * */
	public double getY() {
		return y;
	}
}
