package Worms;

class Grenade {
	private double x = 0;
	private double y = 0;
	double dx = 10;
	double dy = 10;
	double time=0;
	double delay;
	int rotation;

	/**
	 * Konstruktor
	 * @param posX x-ova pozicia naboja
	 * @param posY y-ova pozicia naboja
	 * @param dx x-ova rychlost
	 * @param dy y-ova rychlost
	 */
	public Grenade(double posX,double posY,double dx, double dy) {
		super();
		this.x = posX;
		this.y = posY;
		this.dx = dx;
		this.dy=dy;
		this.delay=0;
		rotation =0;
	}

	/**
	 * Posúva naboj
	 * @param h vyska sceny
	 * @param w sirka sceny
	 * @return false= naboj mimo sceny, true= naboj je vnutri sceny
	 */
	public boolean update(int h,int w) {
		if (x < 0 || y < 0 || x > w || y > h) {
			return false;
		}
		dy = dy+time;
		time = time +  0.01;
		x += dx;
		y += dy;
		if(dy<3){
			delay +=0.05;
		}
		else{
		delay +=0.2;
		}
		return true;
	}

	/**
	 * vrati X
	 * @return X
	 */
	public double getX() {
		return x;
	}
	/**
	 * vrati Y
	 * @return y
	 */
	public double getY() {
		return y;
	}
	/**
	 * vrati rotaciu
	 * @return rotacia
	 */
	public int getRotation() {
		return rotation;
	}
	/**
	 * zvysi rotaciu
	 * @param r kolko rotacie sa prida
	 */
	public void plusRotation(int r) {
		rotation +=r;
	}
}
