package Worms;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.image.*;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;
/**
 * @author Tomas Matko
 * Projekt Worms, Hlavna trieda v ktorej umiestnujem Pane.
 */
public class Worms extends Application {
	Stage stage = new Stage();
	
	@Override
	/**
	 * Inicializacia stagu s prvou scenov obsahujucou vyber mapy a startom.
	 */
	public void start(Stage primaryStage) {

		StartPane panel = new StartPane(this);
		Scene scene = new Scene(panel, 1000, 800);
		scene.setCursor(Cursor.CROSSHAIR);
		stage = primaryStage;
		stage.setTitle("Worms");
		stage.setScene(scene);
		stage.show();

		Timeline a1 = new Timeline(new KeyFrame(Duration.millis(20),new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				panel.paintBallPane();
			}
		}));
		a1.setCycleCount(-1);
		a1.play();
	}


	/**
	 * Priradenie druhej sceny k stagu,inic. a spustenie animacii vykreslujucich Pane
	 * @param id udava ktora z mapiek je vybrata
	 * @param hp udava kolko hp budu wormsovia mat
	 * @param teamsize udava kolko wormsov bude na mapke
	 */
	public void startGame(int id,int hp,int teamsize){
		WormsPane panel = new WormsPane(id,hp,teamsize);
		Scene scene = new Scene(panel, 1000, 800);
		scene.setCursor(Cursor.CROSSHAIR);
		stage.setScene(scene);
		stage.show();
		Timeline animation = new Timeline(new KeyFrame(Duration.millis(20),new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				panel.paintBallPane();
				panel.paintBullet();
				panel.paintWorm();
				panel.paintGrenade();
				panel.checkDeaths();
			}
		}));
		animation.setCycleCount(-1);
		animation.play();
		Timeline timer = new Timeline(new KeyFrame(Duration.seconds(1),new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent event) {
				panel.timer();
			}
		}));
		timer.setCycleCount(-1);
		timer.play();

	}

	/**
	 * Startuje javafx
	 * @param args argumenty
	 */
	public static void main(String[] args) {
		launch(args);
	}
}


