package Worms;

import javafx.scene.image.*;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

class WormsPane extends Pane {
	private final Image bckgrnd = new Image("bckgrnd.png");
	private final Image imgRight = new Image("RWorm.png");
	private final Image imgLeft = new Image("LWorm.png");
	private final Image grnd = new Image("Grenade.png");
	private final Image baz = new Image("Bazooka.png");
	private final Image map1 = new Image("Map1.png");
	private final Image map2 = new Image("Map2.png");
	private final Image map3 = new Image("Map3.png");
	private final Image map4 = new Image("Map4.png");
	private final Image radiusB = new Image("radiusB.png");
	private final Image radiusG = new Image("radiusG.png");
	private final Image sea = new Image("sea.png");
	private final Image tomb = new Image("Ts.png");
	private final Image arrow = new Image ("arrow.png");

	private Random rnd = new Random();
	private WritableImage wi = new WritableImage(1000,800);

	private double mx, my;
	private final int WormSize = 25;
	private final int w = 1000;
	private final int h = 800;

	private ImageView mapa;
	private ImageView zbran = new ImageView(baz);
	private ImageView seaView = new ImageView(sea);
	private List<Bullet> bullets = new ArrayList<Bullet>();
	private List<Grenade> grenades = new ArrayList<Grenade>();
	private List<Worm> WormG = new ArrayList<Worm>();
	private List<Worm> WormR = new ArrayList<Worm>();
	private Worm wormR;
	private Worm wormG;
	private boolean preparedMap;
	private int teamsize=2;

	/**
     * tah = farba tymu ktory je na tahu
	 */
	Color tah;
	/**
	 * maxhp = kolko maxhp budu mat wormsovia
	 */
	int maxhp;
	/**
	 * urcuje vysku mora
	 */
	int seaLevel = h-10;
	/**
	 * zac = urcuje ci je skonecna faza ukladania wormsov
	 */
	boolean zac = true;
	/**
	 * bazuka = urcuje ci je aktivna bazuka alebo granat
	 */
	boolean bazuka = true;
	/**
	 * koniec = urcuje ktory tym vyhral
	 */
	Color koniec;
	/**
	 * counter = pocita timer
	 */
	int counter=30;
	/**
	 * id = ktora mapka je zvolena
	 */
	int id;

	/**
	 * Konstruktor
	 * @param id udava ktora z mapiek je vybrata
	 * @param hp udava kolko je nastavenych hp
	 * @param teamsize udava kolko wormsov bude v teame
	 *
	 */
	public WormsPane (int id,int hp,int teamsize) {
		this.id = id;
		this.maxhp = hp;
		this.teamsize=teamsize;
	}

	/**
	 * Hlavne metoda programu ktora riesi ci skoncila hra,ci je nastavena mapka,ci su nastaveny wormsovia,nakoniec spusta metody gui a updateWorm.
	 */
	protected void paintBallPane() {
		getChildren().clear();

		if(!zac && wormG==null){
			wormG = rndWorm(Color.GREEN);
		}
		if(!zac && wormR==null){
			wormR = rndWorm(Color.RED);
		}

		if (preparedMap) {
			getChildren().add(mapa);
			seaView.setY(seaLevel);

			getChildren().add(seaView);
		}
		if (koniec == Color.GREEN || koniec == Color.RED ) {
			end(koniec);
					}
		else {
			this.setOnMouseMoved(e -> {
				mx = e.getX();
				my = e.getY();
			});
			if (tah != null) {
				nextText();
			}
			if (zac || WormR.size()!=teamsize || WormG.size()!=teamsize) {
				if (zac && WormR.size()==0) {
					if (!preparedMap) {
						prepareMap();
					}
					Text rad = new Text();
					rad.setX(25);
					rad.setY(25);
					rad.setFont(Font.font("Verdana", 20));
					rad.setText("Hru zacina cerveny umiestnenim svojho wormsa");
					getChildren().add(rad);
				}
				positionWorms();
				ImageView a = new ImageView();
				a.setImage(imgRight);
				a.setFitHeight(WormSize);
				a.setFitWidth(WormSize);
				a.setX(mx);
				a.setY(my);
				getChildren().add(a);
			} else {
				gui();
				updateWorm();
			}
		}
	}

	/**
	 * Metoda kontroluje ktory hrac je na tahu a ktora zbran je zvolena, poďla toho vola a predava argumenty metodam AddBullet,AddGrenade.
	 */
	public void updateWorm() {
		if (tah == Color.RED) {
			this.setOnMouseReleased(e -> {
				if (e.getButton() == MouseButton.SECONDARY) {
					if (bazuka) bazuka = false;
					else bazuka = true;
				}
				if(e.getButton() == MouseButton.PRIMARY){
					if(bazuka){
						addBullet(wormR.getX() + WormSize / 2, wormR.getY() + WormSize / 2, mx, my);
					}
					else{
						if(wormR.gammo>0){
							addGrenade(wormR.getX() + WormSize / 2, wormR.getY() + WormSize / 2, mx, my);
							wormR.gammo = wormR.gammo - 1 ;
						}
						else{
							bazuka=true;
						}
					}
				}
			});
		}
		if (tah == Color.GREEN) {
			this.setOnMouseReleased(e -> {
				if (e.getButton() == MouseButton.SECONDARY) {
					if (bazuka) bazuka = false;
					else bazuka = true;
				}
				if(e.getButton() == MouseButton.PRIMARY){
					if(bazuka){
						addBullet(wormG.getX() + WormSize / 2, wormG.getY() + WormSize / 2, mx, my);
					}
					else{
						if(wormG.gammo>0){
							addGrenade(wormG.getX() + WormSize / 2, wormG.getY() + WormSize / 2, mx, my);
							wormG.gammo = wormG.gammo - 1 ;
						}
						else{
							bazuka=true;
						}
					}
				}
			});
		}
	}

	/**
	 * Vybere ktory cervik z tymu bude nasledovat ako dalsi na rade
	 * @param farba urcuje ktoremu tymu urcujeme wormsa
	 * @return vrati jedneho nahodneho cervika farby z argumentu
	 */
	public Worm rndWorm(Color farba) {
		Worm a = WormG.get(rnd.nextInt(teamsize));
		Worm b = WormR.get(rnd.nextInt(teamsize));
		if (farba == Color.GREEN) {
			while (a.hp <=0) {
				a = WormG.get(rnd.nextInt(teamsize));
			}
		}
		if (farba == Color.RED) {
			while (b.hp <= 0) {
				b = WormG.get(rnd.nextInt(teamsize));
			}
			a = b;
		}
		return a;
	}

	/**
	 * Metoda je volana pri zaciatku hry, poklada wormsov na miesto kde hrac klikne (vola addWorm).
	 */
	public void positionWorms(){
		if(tah== Color.GREEN) {
			this.setOnMouseReleased(e -> {
				PixelReader pr = mapa.getImage().getPixelReader();
				if(pr.getArgb((int) e.getX()+WormSize/2, (int) e.getY()+WormSize/2) == 0) {
					addWorm(mx, my, Color.GREEN);
					tah=Color.RED;
				}
			});
		}
		else{
			this.setOnMouseReleased(e -> {
				PixelReader pr = mapa.getImage().getPixelReader();
				if(pr.getArgb((int) e.getX()+WormSize/2, (int) e.getY()+WormSize/2) == 0) {
					addWorm(mx, my, Color.RED);
					tah=Color.GREEN;
				}
			});
		}
		if(WormR.size()==teamsize && WormG.size()==teamsize){
			zac=false;
		}

	}

	/**
	 * Metoda vytvori noveho wormsa s hodnotami argumentov,nastavi ho do triednej premmenej.
	 * @param mx x-ova pozicia wormsa(mysky)
	 * @param my y-ova pozicia wormsa(mysky)
	 * @param farba farba hraca ktory bol na tahu ked bola zavolana metoda
	 */
	public void addWorm(double mx,double my,Color farba){
		if(farba == Color.RED){
			Worm a = new Worm(mx,my,maxhp);
			WormR.add(a);
		}
		else if(farba == Color.GREEN){
			Worm a = new Worm(mx,my,maxhp);
			WormG.add(a);
		}

	}

	/**
	 * Metoda vykresluje Wormsa a jeho zivot,natocenie za myskou,smrt. Ak je Worms vo vzduchu znizuje jeho vysku kym nenarazi na zem
	 */
	public void paintWorm(){
		if(WormG.size()!=0){
			for(Worm wormG:WormG) {
				PixelReader pr = mapa.getImage().getPixelReader();
				if (wormG.y + WormSize < h && pr.getArgb((int) wormG.x + WormSize / 2, (int) wormG.y + WormSize) == 0) {
					wormG.y += 4;
				}
				ImageView a = new ImageView();
				if (wormG.smer == 0) {
					a.setImage(imgRight);
				} else {
					a.setImage(imgLeft);
				}
				if (wormG.hp<=0){
					a.setImage(tomb);
				}
				a.setFitHeight(WormSize);
				a.setFitWidth(WormSize);
				a.setX(wormG.getX());
				a.setY(wormG.getY());
				getChildren().add(a);
				if (wormG.hp>0) {
					Text hp = new Text();
					hp.setText("" + wormG.hp);
					hp.setX(wormG.getX());
					hp.setY(wormG.getY() - 10);
					hp.setFill(Color.GREEN);
					getChildren().add(hp);
				}
			}
		}
		if(WormR.size()!=0){
			for(Worm wormR:WormR) {
				PixelReader pr = mapa.getImage().getPixelReader();
				if (wormR.y + WormSize < h && pr.getArgb((int) wormR.x + WormSize / 2, (int) wormR.y + WormSize) == 0) {
					wormR.y += 4;
				}
				ImageView a = new ImageView();
				if (wormR.smer == 0) {
					a.setImage(imgRight);
				} else {
					a.setImage(imgLeft);
				}
				if (wormR.hp<=0){
					a.setImage(tomb);
				}
				a.setFitHeight(WormSize);
				a.setFitWidth(WormSize);
				a.setX(wormR.getX());
				a.setY(wormR.getY());
				getChildren().add(a);
				if (wormR.hp>0) {
					Text hp = new Text();
					hp.setText("" + wormR.hp);
					hp.setX(wormR.getX());
					hp.setY(wormR.getY() - 10);
					hp.setFill(Color.GREEN);
					getChildren().add(hp);
				}

			}
		}
	}

	/**
	 * Metoda vytvara novy projektil a uklada ho do listu nabojov ktore su momentalne na mape
	 * @param xx x-ova suradnica stredu wormsa
	 * @param yy y-ova suradnica stredu wormsa
	 * @param mx x-ova suradnica mysi
	 * @param my y-ova suradnica mysi
	 */
	public void addBullet(double xx, double yy,double mx,double my){
                    Bullet a = new Bullet(xx,yy,(-xx+mx)/40,(-yy+my)/40);
					changePlayer();
                    bullets.add(a);
        }

	/**
	 * Vykresluje vsetky aktivne projektily a riesi kolizie
 	 */
	public void paintBullet(){
			cyklus:
            for(Bullet i:bullets){
            	if(i.update(h,w)==false){
            		bullets.remove(i);
					break cyklus;
				}
            	else {
					Circle s = new Circle();
					s.setRadius(5);
					s.setCenterY(i.getY());
					s.setCenterX(i.getX());
					for(Worm wormR:WormR) {
						for(Worm wormG:WormG) {
							if(wormR==null || wormG ==null)break;
							Rectangle r = new Rectangle();
							r.setX(wormR.getX());
							r.setY(wormR.getY());
							r.setHeight(WormSize);
							r.setWidth(WormSize);
							Rectangle g = new Rectangle();
							g.setX(wormG.getX());
							g.setY(wormG.getY());
							g.setHeight(WormSize);
							g.setWidth(WormSize);
							if (i.getX() > w || i.getY() > h || i.getX() < 0 || i.getY() < 0) {
								bullets.remove(i);
								break cyklus;
							}

							PixelReader pr = mapa.getImage().getPixelReader();
							for (double j = i.getX(); j < i.getX() + 5; j++) {
								if (pr.getArgb((int) j, (int) i.getY()) != 0) {
									bullets.remove(i);
									destroy((int) i.getX(), (int) i.getY(), bazuka);
									break cyklus;
								}
							}


							if (s.getLayoutBounds().intersects(g.getLayoutBounds()) && i.delay > 1) {
								bullets.remove(i);
								wormG.takeDamage(20);
								destroy((int) i.getX()+WormSize/2, (int) i.getY()+WormSize/2, bazuka);
								break cyklus;
							}
							if (s.getLayoutBounds().intersects(r.getLayoutBounds()) && i.delay > 1) {
								bullets.remove(i);
								wormR.takeDamage(20);
								destroy((int) i.getX()+WormSize/2, (int) i.getY()+WormSize/2, bazuka);
								break cyklus;
							}
						}
					}
					getChildren().add(s);
				}
            }
        }
	/**
	 * Metoda vytvara novy granat a uklada ho do listu granatov ktore su momentalne na mape
	 * @param xx x-ova suradnica stredu wormsa
	 * @param yy y-ova suradnica stredu wormsa
	 * @param mx x-ova suradnica mysi
	 * @param my y-ova suradnica mysi
	 */
	public void addGrenade(double xx, double yy,double mx,double my){
		Grenade a = new Grenade(xx,yy,(-xx+mx)/40,(-yy+my)/40);
		changePlayer();
		grenades.add(a);

	}

	/**
	 * Vykresluje vsetky aktivne granaty a riesi kolizie
	 */
	public void paintGrenade(){
		cyklus:
		for(Grenade i:grenades){
			if(i.update(h,w)==false){
				bullets.remove(i);
				break;
			}
			else {
				ImageView s = new ImageView(grnd);
				s.setFitHeight(25);
				s.setFitWidth(25);
				s.setY(i.getY());
				s.setX(i.getX());
				i.plusRotation(rnd.nextInt(10));
				s.setRotate(i.getRotation());
				for(Worm wormR:WormR) {
					for(Worm wormG:WormG) {
						if(wormR==null || wormG ==null)break;
						Rectangle r = new Rectangle();
						r.setX(wormR.getX());
						r.setY(wormR.getY());
						r.setHeight(WormSize);
						r.setWidth(WormSize);
						Rectangle g = new Rectangle();
						g.setX(wormG.getX());
						g.setY(wormG.getY());
						g.setHeight(WormSize);
						g.setWidth(WormSize);

						if (i.getX() > w || i.getY() > h || i.getX() < 0 || i.getY() < 0) {
							grenades.remove(i);
							break cyklus;
						}

						PixelReader pr = mapa.getImage().getPixelReader();
						for (double j = i.getX(); j < i.getX() + 5; j++) {
							if (pr.getArgb((int) j, (int) i.getY()) != 0) {
								grenades.remove(i);
								destroy((int) i.getX(), (int) i.getY(), bazuka);
								break cyklus;
							}
						}

						if (s.getLayoutBounds().intersects(g.getLayoutBounds()) && i.delay > 1) {
							grenades.remove(i);
							destroy((int) i.getX()+WormSize/2, (int) i.getY()+WormSize/2, bazuka);
							wormG.takeDamage(25);
							break cyklus;
						}
						if (s.getLayoutBounds().intersects(r.getLayoutBounds()) && i.delay > 1) {
							grenades.remove(i);
							destroy((int) i.getX()+WormSize/2, (int) i.getY()+WormSize/2, bazuka);
							wormR.takeDamage(25);
							break cyklus;
						}
					}
				}
				getChildren().add(s);
			}
		}
	}

	/**
	 * Vykresluje zvolenu mapku pred prvym zobrazenim
	 */
	public void prepareMap(){
		PixelReader pr;
		switch(id) {
			case 1:pr = map1.getPixelReader();break;
			case 2:pr = map2.getPixelReader();break;
			case 3:pr = map3.getPixelReader();break;
			case 4:pr = map4.getPixelReader();break;
			default:pr = map1.getPixelReader();break;
		}
		this.wi = new WritableImage(1000,800);
		PixelWriter pw = this.wi.getPixelWriter();
		for (int y = 0; y < h; y++) {
			for (int x = 0; x < w; x++) {
				Color c = pr.getColor(x,y);
				if(pr.getColor(x,y)== Color.WHITE){
					pw.setArgb(0,x,y);
				}
				else{
					pw.setColor(x, y, c);
				}
			}
		}
		this.mapa = new ImageView(this.wi);
		mapa.setX(0);
		mapa.setY(0);
		mapa.setFitHeight(wi.getHeight());
		mapa.setFitWidth(wi.getWidth());
		getChildren().add(mapa);
		this.seaView = new ImageView(sea);
		seaView.setY(seaLevel);
		seaView.setX(0);
		getChildren().add(seaView);
		preparedMap=true;

	}

	/**
	 * Vykresluje timer,zbran,ammo,trigger,nataca wormsov za kurzorom
	 */
	public void gui(){
		/*ImageView bckgn = new ImageView(bckgrnd);
		bckgn.setX(0);
		bckgn.setY(0);
		bckgn.setFitHeight(800);
		bckgn.setFitWidth(1000);
		getChildren().add(bckgn);*/
		ImageView id = new ImageView(arrow);
		id.setFitHeight(25);
		id.setFitWidth(25);
		if(tah==Color.GREEN){
			id.setX(wormG.getX());
			id.setY(wormG.getY()-50);
			if(mx>wormG.x){
				wormG.smer =0;
			}
			else{
				wormG.smer =1;
			}
		}
		if(tah==Color.RED){
			id.setX(wormR.getX());
			id.setY(wormR.getY()-50);
			if(mx>wormR.x){
				wormR.smer =0;
			}
			else{
				wormR.smer =1;
			}
		}
		getChildren().add(id);
		Text Timer=new Text();
		Timer.setX(25);
		Timer.setY(50);
		Timer.setFont(Font.font("Verdana", 20));
		Timer.setText("Timer : " + counter);
		Timer.setFill(tah);
		getChildren().add(Timer);
		/*Circle trigger = new Circle(); //stare vykreslovanie crosshairu, nove je cez setcursor -.-
		trigger.setCenterX(mx);
		trigger.setCenterY(my);
		trigger.setRadius(10);
		trigger.setFill(Color.TRANSPARENT);
		trigger.setStroke(Color.BLACK);
		getChildren().add(trigger);
		Line a = new Line();
		a.setStartX(mx + 5);
		a.setEndX(mx + 15);
		a.setStartY(my);
		a.setEndY(my);
		getChildren().add(a);
		Line b = new Line();
		b.setStartX(mx - 5);
		b.setEndX(mx - 15);
		b.setStartY(my);
		b.setEndY(my);
		getChildren().add(b);
		Line c = new Line();
		c.setStartX(mx);
		c.setEndX(mx);
		c.setStartY(my + 5);
		c.setEndY(my + 15);
		getChildren().add(c);
		Line d = new Line();
		d.setStartX(mx);
		d.setEndX(mx);
		d.setStartY(my - 5);
		d.setEndY(my - 15);
		getChildren().add(d);*/
		if(bazuka){
			zbran = new ImageView(baz);
				Text ammo = new Text("∞");
				ammo.setY(25);
				ammo.setX(w-125);
				ammo.setFont(Font.font("Verdana", 20));
				ammo.setFill(tah);
				getChildren().add(ammo);
		}
		else{
			zbran = new ImageView(grnd);
			if(tah==Color.GREEN){
				Text ammo = new Text("" + wormG.gammo);
				ammo.setY(25);
				ammo.setX(w-125);
				ammo.setFont(Font.font("Verdana", 20));
				ammo.setFill(tah);
				getChildren().add(ammo);
			}
			else{
				Text ammo = new Text("" + wormR.gammo);
				ammo.setY(25);
				ammo.setX(w-125);
				ammo.setFont(Font.font("Verdana", 20));
				ammo.setFill(tah);
				getChildren().add(ammo);
			}


		}
		zbran.setX(w-108);
		zbran.setY(8);
		zbran.setFitWidth(100);
		zbran.setFitHeight(100);
		getChildren().add(zbran);

	}

	/**
	 * Vykresluje text ktory hovori kto je dalsi na tahu
	 */
	public void nextText(){
		Text rad = new Text();
		rad.setX(25);
		rad.setY(25);
		rad.setFont(Font.font("Verdana", 20));
		rad.setText("Na tahu je ");
		rad.setFill(tah);
		getChildren().add(rad);
		Rectangle f = new Rectangle();
		f.setFill(tah);
		f.setY(8);
		f.setX(140);
		f.setWidth(20);
		f.setHeight(20);
		getChildren().add(f);
	}

	/**
	 * Riesi vykreslenie kolizie terenu a naboja,"odkusuje" kusky mapy podla polohy kolizie a typu zbrane
	 * @param x x-ova pozicia pixelu mapy kde nastala kolizia
	 * @param y	y-ova pozicia pixelu mapy kde nastala kolizia
	 * @param b urcuje ktora zbran bola pouzita pri kolizii
	 */
	public void destroy(int x,int y,boolean b){
		if(b){
			PixelReader pr = mapa.getImage().getPixelReader();
			PixelReader prhelp = radiusB.getPixelReader();
			PixelWriter pw = this.wi.getPixelWriter();
			x=x-25;
			y=y-25;
			for (int i = 1; i < 50; i++) {
				for (int j = 1; j < 50; j++) {
					if(i+x>=w || j+y>=h || i+x<=0 || j+y<=0 ){
						continue;
					}
					else{
						if (pr.getArgb(i+x, j+y) != 0 && prhelp.getArgb(i,j) != 0) {
							pw.setArgb(i+x,j+y,0);
						}
					}

				}
			}
			this.mapa = new ImageView(this.wi);
		}
		else{
			PixelReader pr = mapa.getImage().getPixelReader();
			PixelReader prhelp = radiusG.getPixelReader();
			PixelWriter pw = this.wi.getPixelWriter();
			x=x-75;
			y=y-75;
			for (int i = 1; i < 150; i++) {
				for (int j = 1; j < 150; j++) {
					if(i+x>=w || j+y>=h || i+x<=0 || j+y<=0 ){
						continue;
					}
					else{
						if (pr.getArgb(i+x, j+y) != 0 && prhelp.getArgb(i,j) != 0) {
							pw.setArgb(i+x,j+y,0);
						}
					}
				}
			}
			this.mapa = new ImageView(this.wi);
		}

		}

	/**
	 * Metoda je zavolana na konci hry,vynuluje premenne ktore su pouzivane pri hre,vypise vyhercu
	 * oznamuje kto vyhral
	 * @param win urcuje kto vyhral hru
	 */
	public void end(Color win){
		Text rad = new Text();
		rad.setX(25);
		rad.setY(25);
		rad.setFont(Font.font("Verdana", 20));
		this.setOnMouseReleased(e -> {
			koniec=null;
			zac = true;
			WormG = new ArrayList<Worm>();
			WormR = new ArrayList<Worm>();
			wormG = null;
			wormR = null;
			bullets = new ArrayList<Bullet>();
			tah = null;
			preparedMap = false;
			seaLevel=h-10;
		});
		if (win==Color.RED) {
			rad.setFill(Color.RED);
			rad.setText("Hru vyhral cerveny tim. Pre zacatie novej hry stlacte tlacidlo mysi.");
			getChildren().add(rad);

		} else {
			rad.setFill(Color.GREEN);
			rad.setText("Hru vyhral zeleny tim. Pre zacatie novej hry stlacte tlacidlo mysi.");
			getChildren().add(rad);
		}
	}

	/**
	 * Metoda kontroluje ci su wormsovia nazive
	 */
	public void checkDeaths(){

		int counter =0;
			for(Worm g:WormG){
				if(g.hp<=0)counter++;
				if(g.y>seaLevel){
					g.hp=0;
				}
			}
			if(counter==teamsize){
				koniec=Color.RED;
			}
			counter=0;

			for(Worm r:WormR){
				if(r.hp<=0)counter++;
				if(r.y>seaLevel){
					r.hp=0;
				}
			}
			if(counter==teamsize){
				koniec=Color.GREEN;
			}


	}

	/**
	 * Spravuje timer
	 */
	public void timer(){
		if(!zac){
			counter-=1;
			if(counter<=0){
				changePlayer();
			}

		}

	}

	/**
	 * Meni ktory worm je na rade,zdviha hladinu mora
	 */
	public void changePlayer(){
		if(seaLevel>100){
			seaLevel = seaLevel-5;
		}



		if(tah==Color.GREEN){
			wormG = rndWorm(tah);
			this.tah=Color.RED;


		}
		else if(tah==Color.RED){
			wormR = rndWorm(tah);
			this.tah=Color.GREEN;
		}
		counter =30;
		}
}
