import {
  elementsCreateConference,
  elementsConference
} from "../views/basicView.js";
import * as conferenceView from "../views/conferenceView.js";
import * as commonFunctions from "./commonFunctions.js";
import Conference from "../models/Conference.js";

//create conference

let conference;

elementsCreateConference.createForm.addEventListener("submit", () => {
  event.preventDefault();
  const input = conferenceView.getCreateFormInput();
  if (!conferenceView.control(input)) {
    commonFunctions.showFeedback(
      commonFunctions.strings.incorrectDates,
      elementsCreateConference.feedbackCreate,
      "danger"
    );
  } else {
    elementsCreateConference.createConference.classList.add("hidden");
    conference = new Conference(input.name, input.startDate, input.finishDate);
    conferenceView.setConferenceTitle(conference.name);
    manageConference();
  }
});

// conference

function manageConference() {
  elementsConference.conferenceMain.classList.remove("hidden");
  conference.dates.forEach(element => {
    conferenceView.renderDay(element);
  });
}

elementsConference.schedule.addEventListener("click", () => {
  if (event.target.matches(".new-room-btn, .new-room-btn *")) {
    conferenceView.renderRoom(event.target.closest(".schedule-day"));
  } else if (event.target.matches(".btn-plus")) {
    conferenceView.renderCell(event.target.closest(".schedule-room-container"));
  }
  // else if (event.target.matches(".btn-new-section")) {
  //   conferenceView.renderSection(
  //     event.target.closest(".schedule-room-container")
  //   );
  // }
});

elementsConference.switch.addEventListener("click", () => {
  elementsConference.panelChair.classList.toggle("hidden");
  elementsConference.panelContribution.classList.toggle("hidden");
});

let draggedItem;

elementsConference.panelList.addEventListener("dragstart", () => {
  try {
    if (event.target.matches(".draggable")) {
      draggedItem = event.target; // to remember last dragged element
      console.log("Dragged item");
      console.log(draggedItem);

      conferenceView.dragStart(event.target);
    }
  } catch (e) {
    console.log(e); //will be solved differently
  }
});

elementsConference.panelList.addEventListener("dragend", () => {
  conferenceView.dragEnd(event.target); // to get to initial state after dragging
});

elementsConference.schedule.addEventListener("dragover", () => {
  event.preventDefault();
});

// elementsConference.schedule.addEventListener("dragenter", () => {
//   return false;
// });

// elementsConference.schedule.addEventListener("dragleave", () => {
//   return false;
// });

elementsConference.schedule.addEventListener("drop", () => {
  event.preventDefault();
  if (event.target.matches(".schedule-chair, .schedule-chair *")) {
    if (draggedItem.classList.contains("panel-chair")) {
      conferenceView.lengthControl(event.target, draggedItem);
      conferenceView.correctDrop(event.target, draggedItem);
    }
  } else if (event.target.matches(".schedule-topic, .schedule-topic *")) {
    if (
      draggedItem.classList.contains("panel-special") ||
      draggedItem.classList.contains("panel-contribution")
    ) {
      conferenceView.correctDrop(event.target, draggedItem);
      if (draggedItem.classList.contains("panel-special")) {
        console.log("podm1:");
        console.log(event.target.parentElement);

        conferenceView.setAttribute(
          event.target.closest(".schedule-double-item"),
          "background: grey"
        );
      } else {
        console.log("podm2:");
        console.log(event.target.parentElement);
        conferenceView.setAttribute(
          event.target.closest(".schedule-double-item"), //event.target.parentElement
          "background: var(--mainDark)"
        );
      }
    }
  }
});
