import { elementsContribution } from "../views/basicView.js";
import ContributionList from "../models/ContributionList.js";
import * as contributionView from "../views/contributionView.js";

const state = {
  contributionList: new ContributionList()
};

elementsContribution.addForm.addEventListener("submit", sendAddingForm);

function sendAddingForm(event) {
  event.preventDefault();
  const input = contributionView.getInput();
  const item = state.contributionList.addItem(
    input.title,
    input.author,
    input.abstract,
    input.powerpoint
  );
  contributionView.renderItem(item);
  contributionView.clearInput();
}

let saveId;

elementsContribution.enrollmentItems.addEventListener("click", () => {
  const id = parseInt(event.target.closest(".enrollment-item").dataset.id);
  if (event.target.matches(".delete-icon, .delete-icon *")) {
    //to do : confirmation
    state.contributionList.removeItem(id);
    contributionView.deleteItem(id);
  } else if (event.target.matches(".edit-icon, .edit-icon *")) {
    const item = state.contributionList.getItem(id);
    contributionView.setInput(item);
    contributionView.toEditIcon();
    elementsContribution.addForm.removeEventListener("submit", sendAddingForm);
    elementsContribution.addForm.addEventListener("submit", sendEditingForm);
    saveId = id;
  }
});

function sendEditingForm(event) {
  event.preventDefault();
  const input = contributionView.getInput();
  const obj = state.contributionList.updateItem(
    saveId,
    input.title,
    input.author,
    input.abstract,
    input.powerpoint
  );
  contributionView.updateItem(obj);
  contributionView.clearInput();
  contributionView.toAddIcon();
  elementsContribution.addForm.removeEventListener("submit", sendEditingForm);
  elementsContribution.addForm.addEventListener("submit", sendAddingForm);
}
