import { elementsCommittee, elementsChair } from "../views/basicView.js";
import CommitteeList from "../models/CommitteeList.js";
import ChairList from "../models/ChairList.js";
import * as committeeView from "../views/committeeView.js";
import * as chairView from "../views/chairView.js";
import * as commonFunctions from "./commonFunctions.js";

const state = {
  committeeList: new CommitteeList(),
  chairList: new ChairList()
};

// Committee controller

elementsCommittee.addCommitteeForm.addEventListener(
  "submit",
  sendCommitteeAddingForm
);

function sendCommitteeAddingForm(event) {
  event.preventDefault();
  const input = committeeView.getCommitteeInput();
  if (!committeeView.controlCommittee(input.password)) {
    commonFunctions.showFeedback(
      commonFunctions.strings.shortPassword,
      elementsCommittee.feedbackCommittee,
      "danger"
    );
  } else {
    commonFunctions.removeFeedback(
      elementsCommittee.feedbackCommittee,
      "danger"
    );
    const item = state.committeeList.addItem(
      input.name,
      input.login,
      input.password
    );
    committeeView.renderCommitteeItem(item);
    committeeView.clearCommitteeInput();
  }
}

let saveCommitteeId;

elementsCommittee.committeeItems.addEventListener("click", () => {
  const id = parseInt(
    event.target.closest(".enrollment-item").dataset.committeeid
  );
  if (event.target.matches(".delete-icon, .delete-icon *")) {
    //to do : confirmation
    state.committeeList.removeItem(id);
    committeeView.deleteItem(id); //refactorise to superclass?
  } else if (event.target.matches(".edit-icon, .edit-icon *")) {
    const item = state.committeeList.getItem(id);
    committeeView.setCommitteeInput(item);
    committeeView.toEditIcon();
    elementsCommittee.addCommitteeForm.removeEventListener(
      "submit",
      sendCommitteeAddingForm
    );
    elementsCommittee.addCommitteeForm.addEventListener(
      "submit",
      sendCommitteeEditingForm
    );
    saveCommitteeId = id;
  }
});

function sendCommitteeEditingForm(event) {
  event.preventDefault();
  const input = committeeView.getCommitteeInput();
  if (!committeeView.controlCommittee(input.password)) {
    commonFunctions.showFeedback(
      commonFunctions.strings.shortCommitteeInput,
      elementsCommittee.feedbackCommittee,
      "danger"
    );
  } else {
    commonFunctions.removeFeedback(
      elementsCommittee.feedbackCommittee,
      "danger"
    );
    const obj = state.committeeList.updateItem(
      saveCommitteeId,
      input.name,
      input.login,
      input.password
    );
    committeeView.updateItem(obj);
    committeeView.clearCommitteeInput();
    committeeView.toAddIcon();
    elementsCommittee.addCommitteeForm.removeEventListener(
      "submit",
      sendCommitteeEditingForm
    );
    elementsCommittee.addCommitteeForm.addEventListener(
      "submit",
      sendCommitteeAddingForm
    );
  }
}

// chair controller

elementsChair.addChairForm.addEventListener("submit", sendChairAddingForm);

function sendChairAddingForm(event) {
  event.preventDefault();
  const input = chairView.getChairInput();
  const item = state.chairList.addItem(input.name, input.login);
  chairView.renderChairItem(item);
  chairView.clearChairInput();
}

let saveChairId;

elementsChair.chairItems.addEventListener("click", () => {
  const id = parseInt(event.target.closest(".enrollment-item").dataset.chairid);
  if (event.target.matches(".delete-icon, .delete-icon *")) {
    //to do : confirmation
    state.chairList.removeItem(id);
    chairView.deleteItem(id); //refactorise to superclass?
  } else if (event.target.matches(".edit-icon, .edit-icon *")) {
    const item = state.chairList.getItem(id);
    chairView.setChairInput(item);
    chairView.toEditIcon();
    elementsChair.addChairForm.removeEventListener(
      "submit",
      sendChairAddingForm
    );
    elementsChair.addChairForm.addEventListener("submit", sendChairEditingForm);
    saveChairId = id;
  }
});

function sendChairEditingForm(event) {
  event.preventDefault();
  const input = chairView.getChairInput();
  const obj = state.chairList.updateItem(saveChairId, input.name, input.login);
  chairView.updateItem(obj);
  chairView.clearChairInput();
  chairView.toAddIcon();
  elementsChair.addChairForm.removeEventListener(
    "submit",
    sendChairEditingForm
  );
  elementsChair.addChairForm.addEventListener("submit", sendChairAddingForm);
}
