import ItemList from "./ItemList.js";

export default class ChairList extends ItemList {
  //singleton class
  constructor() {
    super();
    this.usedCodes = [];
  }

  addItem(name, login) {
    const obj = {
      id: this.idCounter++,
      name,
      login: login ? login : this.generateCode()
    };
    this.items.push(obj);
    return obj;
  }

  generateCode() {
    let code;
    do {
      code = (1000000000 + Math.floor(Math.random() * 9000000000)).toString();
    } while (this.usedCodes.includes(code));
    this.usedCodes.push(code);
    return code;
  }

  updateItem(id, name, login) {
    const obj = this.items.find(item => item.id === id);
    obj.name = name;
    obj.login = login ? login : this.generateCode();
    return obj;
  }
}
