export default class Conference {
  constructor(name, start, finish) {
    this.name = name;
    this.start = new Date(start);
    this.finish = new Date(finish);
    this.loadDatesArr();
  }

  loadDatesArr() {
    this.dates = [];
    let currDate = new Date(this.start.valueOf());

    while (currDate <= this.finish) {
      this.dates.push(new Date(currDate.valueOf()));
      currDate.setDate(currDate.getDate() + 1);
    }
  }
}
