import ItemList from "./ItemList.js";

export default class ContributionList extends ItemList {
  constructor() {
    super();
  }

  addItem(title, author, abstract = null, powerpoint = null) {
    const obj = {
      id: this.idCounter++,
      title,
      author,
      abstract,
      powerpoint
    };
    this.items.push(obj);
    return obj;
  }

  updateItem(id, title, author, abstract, powerpoint) {
    const obj = this.items.find(item => item.id === id);
    obj.title = title;
    obj.author = author;
    obj.abstract = abstract;
    obj.powerpoint = powerpoint;
    return obj;
  }
}
