import { elementsChair } from "./basicView.js";

//committee

export function getChairInput() {
  return {
    name: elementsChair.inputChairName.value,
    login: elementsChair.inputChairLogin.value
  };
}

export function setChairInput(item) {
  elementsChair.inputChairName.value = item.name;
  elementsChair.inputChairLogin.value = item.login;
}

export function clearChairInput() {
  elementsChair.inputChairName.value = "";
  elementsChair.inputChairLogin.value = "";
}

export function renderChairItem(item) {
  const html = `
          <article class="enrollment-item" data-chairid="${item.id}">
            <div class="enrollment-info">
              <h2 class="item-name">${item.name}</h2>
              <p class="item-login">${item.login}</p>
            </div>
            <div class="enrollment-icons">
              <button class="edit-icon">
                <i class="fas fa-edit"></i>
              </button>
              <button class="delete-icon">
                X
              </button>
            </div>
          </article>
  `;
  elementsChair.chairItems.insertAdjacentHTML("beforeend", html);
}

export function deleteItem(id) {
  const item = document.querySelector(`[data-chairid="${id}"]`);
  if (item) {
    item.parentElement.removeChild(item);
  }
}

export function updateItem(item) {
  const element = document.querySelector(`[data-chairid="${item.id}"]`);
  const nameElement = element.querySelector(".item-name");
  nameElement.textContent = item.name;
  const loginElement = element.querySelector(".item-login");
  loginElement.textContent = item.login;
}

//superclass both functions:

export function toEditIcon() {
  elementsChair.addEditIconChair.innerHTML = `<i class="fas fa-exchange-alt"></i>`;
  elementsChair.addEditIconChair.title = "Edit chosen contribution";
}

export function toAddIcon() {
  elementsChair.addEditIconChair.innerHTML = `<i class="fas fa-plus-square"></i>`;
  elementsChair.addEditIconChair.title = "Add new contribution";
}
