import { elementsCommittee } from "./basicView.js";

//committee

export function getCommitteeInput() {
  return {
    name: elementsCommittee.inputCommitteeName.value,
    login: elementsCommittee.inputCommitteeLogin.value,
    password: elementsCommittee.inputPassword.value
  };
}

export function setCommitteeInput(item) {
  elementsCommittee.inputCommitteeName.value = item.name;
  elementsCommittee.inputCommitteeLogin.value = item.login;
  elementsCommittee.inputPassword.value = item.password;
}

export function clearCommitteeInput() {
  elementsCommittee.inputCommitteeName.value = "";
  elementsCommittee.inputCommitteeLogin.value = "";
  elementsCommittee.inputPassword.value = "";
}

export function controlCommittee(password) {
  if (password.length < 8) {
    return false;
  }
  return true;
}

export function renderCommitteeItem(item) {
  const html = `
          <article class="enrollment-item" data-committeeid="${item.id}">
            <div class="enrollment-info">
              <h2 class="item-name">${item.name}</h2>
              <p class="item-login">${item.login}</p>
            </div>
            <div class="enrollment-icons">
              <button class="edit-icon">
                <i class="fas fa-edit"></i>
              </button>
              <button class="delete-icon">
                X
              </button>
            </div>
          </article>
  `;
  elementsCommittee.committeeItems.insertAdjacentHTML("beforeend", html);
}

export function deleteItem(id) {
  const item = document.querySelector(`[data-committeeid="${id}"]`);
  if (item) {
    item.parentElement.removeChild(item);
  }
}

export function updateItem(item) {
  const element = document.querySelector(`[data-committeeid="${item.id}"]`);
  const nameElement = element.querySelector(".item-name");
  nameElement.textContent = item.name;
  const loginElement = element.querySelector(".item-login");
  loginElement.textContent = item.login;
}

//superclass both functions:

export function toEditIcon() {
  elementsCommittee.addEditIconCommittee.innerHTML = `<i class="fas fa-exchange-alt"></i>`;
  elementsCommittee.addEditIconCommittee.title = "Edit chosen contribution";
}

export function toAddIcon() {
  elementsCommittee.addEditIconCommittee.innerHTML = `<i class="fas fa-plus-square"></i>`;
  elementsCommittee.addEditIconCommittee.title = "Add new contribution";
}
